/*
 * Decompiled with CFR 0.152.
 */
package cz.mendelu.xotradov;

import com.google.common.annotations.VisibleForTesting;
import cz.mendelu.xotradov.DefaultSorter;
import cz.mendelu.xotradov.MoveType;
import cz.mendelu.xotradov.SimpleQueueComparator;
import cz.mendelu.xotradov.SimpleQueueSorter;
import hudson.model.Queue;
import hudson.model.View;
import hudson.model.queue.QueueSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;

public class MoveActionWorker {
    protected static final Logger logger = Logger.getLogger(MoveActionWorker.class.getName());
    public static final String MOVE_TYPE_PARAM_NAME = "moveType";
    public static final String ITEM_ID_PARAM_NAME = "itemId";
    public static final String VIEW_NAME_PARAM_NAME = "viewName";
    protected boolean isSorterSet = false;

    protected void moveImpl(StaplerRequest request, Queue queue, Jenkins j) {
        try {
            String idParam = request.getParameter(ITEM_ID_PARAM_NAME);
            Queue.Item item = null;
            try {
                item = queue.getItem(Long.parseLong(idParam));
            }
            catch (NumberFormatException nfe) {
                item = this.findIemByName(queue, idParam);
            }
            MoveType moveType = MoveType.valueOf(request.getParameter(MOVE_TYPE_PARAM_NAME));
            View view = j.getView(request.getParameter(VIEW_NAME_PARAM_NAME));
            if (item != null) {
                this.move(queue, item, moveType, view);
                Queue.getInstance().maintain();
            } else {
                logger.info("Wrong item id " + idParam + " (or not found in view " + request.getParameter(VIEW_NAME_PARAM_NAME) + ")");
            }
        }
        catch (IllegalArgumentException iae) {
            logger.info("Wrong move type " + request.getParameter(MOVE_TYPE_PARAM_NAME));
        }
        catch (Exception ex) {
            logger.info("unable to simple-queue item " + request.getParameterMap().entrySet().stream().map(a -> (String)a.getKey() + ": " + Arrays.stream((String[])a.getValue()).collect(Collectors.joining(","))).collect(Collectors.joining("; ")));
        }
    }

    protected Queue.Item findIemByName(Queue queue, String idParam) {
        for (Queue.Item item : queue.getItems()) {
            if (!item.isBuildable() || item.task == null || !item.task.getDisplayName().equals(idParam)) continue;
            return item;
        }
        return null;
    }

    protected void move(@Nonnull Queue queue, @Nonnull Queue.Item item, @Nonnull MoveType moveType, View view) {
        if (view == null || !view.isFilterQueue()) {
            this.moveUnfiltered(queue, item, moveType);
        } else {
            this.moveFiltered(queue, item, moveType, view);
        }
    }

    private void moveUnfiltered(@Nonnull Queue queue, @Nonnull Queue.Item item, @Nonnull MoveType moveType) {
        switch (moveType) {
            case UP_FAST: {
                this.moveToTop(item, queue);
                break;
            }
            case UP: {
                this.moveUp(item, queue);
                break;
            }
            case DOWN: {
                this.moveDown(item, queue);
                break;
            }
            case DOWN_FAST: {
                this.moveToBottom(item, queue);
                break;
            }
        }
    }

    private void moveFiltered(@Nonnull Queue queue, @Nonnull Queue.Item item, @Nonnull MoveType moveType, @Nonnull View view) {
        switch (moveType) {
            case TOP: {
                this.moveToTop(item, queue);
                break;
            }
            case UP_FAST: {
                this.moveToTopFiltered(item, queue, view);
                break;
            }
            case UP: {
                this.moveUpFiltered(item, queue, view);
                break;
            }
            case DOWN: {
                this.moveDownFiltered(item, queue, view);
                break;
            }
            case DOWN_FAST: {
                this.moveToBottomFiltered(item, queue, view);
                break;
            }
            case BOTTOM: {
                this.moveToBottom(item, queue);
            }
        }
    }

    @VisibleForTesting
    public void moveToBottomFiltered(Queue.Item itemToBottom, Queue queue, @Nonnull View view) {
        Queue.Item oldBottomItem = this.getBottom(view.getQueueItems());
        if (oldBottomItem != null) {
            this.putABelowB(itemToBottom, oldBottomItem, queue);
        }
    }

    private void putABelowB(Queue.Item itemToBottom, Queue.Item oldBottomItem, Queue queue) {
        QueueSorter queueSorter;
        Queue.Item[] items = queue.getItems();
        List<Queue.Item> itemsC = this.getItemsBetween(itemToBottom, oldBottomItem, items);
        if (!this.isSorterSet) {
            this.setSorter(queue);
        }
        if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
            SimpleQueueComparator comparator = ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator();
            comparator.addDesire(itemToBottom.getId(), oldBottomItem.getId());
            for (Queue.Item itemC : itemsC) {
                comparator.addDesire(itemToBottom.getId(), itemC.getId());
            }
            this.resort(queue);
        }
    }

    @CheckForNull
    @VisibleForTesting
    public Queue.Item getBottom(@Nonnull List<Queue.Item> queueItems) {
        if (queueItems.size() > 0) {
            return queueItems.get(queueItems.size() - 1);
        }
        return null;
    }

    @VisibleForTesting
    public void moveDownFiltered(Queue.Item itemToDown, Queue queue, View view) {
        Queue.Item oldItemBelow = this.getItemAfter(itemToDown, view.getQueueItems().toArray(new Queue.Item[view.getQueueItems().size()]));
        if (oldItemBelow != null) {
            this.putABelowB(itemToDown, oldItemBelow, queue);
        }
    }

    @VisibleForTesting
    public void moveUpFiltered(Queue.Item itemToUp, Queue queue, View view) {
        Queue.Item oldItemAbove = this.getItemBefore(itemToUp, view.getQueueItems().toArray(new Queue.Item[view.getQueueItems().size()]));
        if (oldItemAbove != null) {
            this.putAOnTopOfB(itemToUp, oldItemAbove, queue);
        }
    }

    private void moveToTopFiltered(@Nonnull Queue.Item item, @Nonnull Queue queue, @Nonnull View view) {
        Queue.Item oldTopItem = this.getTop(view.getQueueItems());
        if (oldTopItem != null) {
            this.putAOnTopOfB(item, oldTopItem, queue);
        }
    }

    @VisibleForTesting
    public void putAOnTopOfB(@Nonnull Queue.Item itemA, @Nonnull Queue.Item itemB, @Nonnull Queue queue) {
        QueueSorter queueSorter;
        Queue.Item[] items = queue.getItems();
        List<Queue.Item> itemsC = this.getItemsBetween(itemA, itemB, items);
        if (!this.isSorterSet) {
            this.setSorter(queue);
        }
        if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
            SimpleQueueComparator comparator = ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator();
            comparator.addDesire(itemB.getId(), itemA.getId());
            for (Queue.Item itemC : itemsC) {
                comparator.addDesire(itemC.getId(), itemA.getId());
            }
            this.resort(queue);
        }
    }

    private List<Queue.Item> getItemsBetween(Queue.Item itemA, Queue.Item itemB, Queue.Item[] items) {
        if (this.isABeforeB(itemA, itemB, items)) {
            return this.getItemsBetweenTopFirst(itemB, itemA, items);
        }
        return this.getItemsBetweenTopFirst(itemA, itemB, items);
    }

    private boolean isABeforeB(Queue.Item itemA, Queue.Item itemB, Queue.Item[] items) {
        List<Queue.Item> itemsBefore = this.getItemsBefore(itemA, items);
        for (Queue.Item item : itemsBefore) {
            if (item.getId() != itemB.getId()) continue;
            return false;
        }
        return true;
    }

    private List<Queue.Item> getItemsBetweenTopFirst(Queue.Item topItem, Queue.Item bottomItem, Queue.Item[] items) {
        ArrayList<Queue.Item> returnList = new ArrayList<Queue.Item>();
        if (items.length > 2) {
            boolean seenBottom = false;
            boolean seenTop = false;
            for (Queue.Item item : items) {
                if (seenTop) continue;
                if (item.getId() == bottomItem.getId()) {
                    seenBottom = true;
                }
                if (!seenBottom) continue;
                if (item.getId() == topItem.getId()) {
                    seenTop = true;
                    continue;
                }
                returnList.add(item);
            }
        }
        return returnList;
    }

    @CheckForNull
    @VisibleForTesting
    public Queue.Item getTop(Collection<Queue.Item> items) {
        int size = items.size();
        if (size > 0) {
            for (int i = size; i > 1; --i) {
                items.iterator().next();
            }
            return items.iterator().next();
        }
        return null;
    }

    @VisibleForTesting
    public void moveToTop(@Nonnull Queue.Item itemA, @Nonnull Queue queue) {
        Queue.Item[] items = queue.getItems();
        List<Queue.Item> itemsB = this.getItemsBefore(itemA, items);
        if (itemsB.size() != 0) {
            QueueSorter queueSorter;
            if (!this.isSorterSet) {
                this.setSorter(queue);
            }
            if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
                SimpleQueueComparator comparator = ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator();
                for (Queue.Item itemB : itemsB) {
                    comparator.addDesire(itemB.getId(), itemA.getId());
                }
                this.resort(queue);
            }
        }
    }

    @VisibleForTesting
    public void moveUp(Queue.Item itemA, Queue queue) {
        Queue.Item[] items = queue.getItems();
        Queue.Item itemB = this.getItemBefore(itemA, items);
        if (itemB != null) {
            QueueSorter queueSorter;
            if (!this.isSorterSet) {
                this.setSorter(queue);
            }
            if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
                ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator().addDesire(itemB.getId(), itemA.getId());
                this.resort(queue);
            }
        }
    }

    @VisibleForTesting
    public void moveDown(Queue.Item itemA, Queue queue) {
        Queue.Item[] items = queue.getItems();
        Queue.Item itemB = this.getItemAfter(itemA, items);
        if (itemB != null) {
            QueueSorter queueSorter;
            if (!this.isSorterSet) {
                this.setSorter(queue);
            }
            if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
                ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator().addDesire(itemA.getId(), itemB.getId());
                this.resort(queue);
            }
        }
    }

    @VisibleForTesting
    public void moveToBottom(@Nonnull Queue.Item itemA, @Nonnull Queue queue) {
        Queue.Item[] items = queue.getItems();
        List<Queue.Item> itemsB = this.getItemsAfter(itemA, items);
        if (itemsB.size() != 0) {
            QueueSorter queueSorter;
            if (!this.isSorterSet) {
                this.setSorter(queue);
            }
            if ((queueSorter = queue.getSorter()) instanceof SimpleQueueSorter) {
                SimpleQueueComparator comparator = ((SimpleQueueSorter)queueSorter).getSimpleQueueComparator();
                for (Queue.Item itemB : itemsB) {
                    comparator.addDesire(itemA.getId(), itemB.getId());
                }
                this.resort(queue);
            }
        }
    }

    @Nonnull
    private List<Queue.Item> getItemsBefore(@Nonnull Queue.Item itemA, @Nonnull Queue.Item[] items) {
        ArrayList<Queue.Item> returnList = new ArrayList<Queue.Item>();
        if (items.length >= 2) {
            boolean seenItemA = false;
            for (Queue.Item item : items) {
                if (seenItemA) continue;
                if (item.getId() == itemA.getId()) {
                    seenItemA = true;
                    continue;
                }
                returnList.add(item);
            }
        }
        return returnList;
    }

    @Nonnull
    private List<Queue.Item> getItemsAfter(@Nonnull Queue.Item itemA, @Nonnull Queue.Item[] items) {
        ArrayList<Queue.Item> returnList = new ArrayList<Queue.Item>();
        if (items.length >= 2) {
            boolean seenItemA = false;
            for (Queue.Item item : items) {
                if (seenItemA) {
                    returnList.add(item);
                    continue;
                }
                if (item.getId() != itemA.getId()) continue;
                seenItemA = true;
            }
        }
        return returnList;
    }

    @CheckForNull
    private Queue.Item getItemAfter(@Nonnull Queue.Item itemA, @Nonnull Queue.Item[] items) {
        if (items.length >= 2) {
            Queue.Item previous = null;
            for (Queue.Item itemB : items) {
                if (previous != null && previous.getId() == itemA.getId()) {
                    return itemB;
                }
                previous = itemB;
            }
        }
        return null;
    }

    @CheckForNull
    private Queue.Item getItemBefore(Queue.Item itemA, Queue.Item[] items) {
        if (items.length >= 2) {
            Queue.Item itemB = null;
            for (Queue.Item itemFor : items) {
                if (itemFor.getId() == itemA.getId()) {
                    return itemB;
                }
                itemB = itemFor;
            }
        }
        return null;
    }

    private void setSorter(Queue queue) {
        if (!this.isSorterSet) {
            Object originalQueueSorter = queue.getSorter();
            if (originalQueueSorter == null) {
                originalQueueSorter = new DefaultSorter();
            }
            SimpleQueueSorter simpleQueueSorter = new SimpleQueueSorter((QueueSorter)originalQueueSorter);
            queue.setSorter((QueueSorter)simpleQueueSorter);
            this.isSorterSet = true;
        }
    }

    private void resort(Queue queue) {
        queue.getSorter().sortBuildableItems(queue.getBuildableItems());
    }
}

