/*
 * Decompiled with CFR 0.152.
 */
package s3explorer;

import hudson.PluginWrapper;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ProminentProjectAction;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;
import s3explorer.S3ExplorerPlugin;

public class S3ExplorerAction
implements ProminentProjectAction,
StaplerProxy {
    private S3ExplorerPlugin plugin = null;
    private AbstractProject<?, ?> project = null;

    public S3ExplorerAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.plugin = (S3ExplorerPlugin)Jenkins.get().getPlugin(S3ExplorerPlugin.class);
    }

    public String getIconFileName() {
        PluginWrapper wrapper = Jenkins.get().getPluginManager().getPlugin(S3ExplorerPlugin.class);
        return this.project.hasPermission(Item.BUILD) ? "/plugin/" + wrapper.getShortName() + "/images/amazon-s3.png" : null;
    }

    public String getDisplayName() {
        return "S3 Explorer";
    }

    public String getUrlName() {
        return "s3explorer";
    }

    public Object getTarget() {
        this.project.checkPermission(Item.BUILD);
        return this;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getBucketName() {
        return this.plugin.getBucketName();
    }

    public String getAwsRegion() {
        return this.plugin.getAwsRegion();
    }

    public String getAwsAccessKeyId() {
        return this.plugin.getAwsAccessKeyId();
    }

    public String getAwsSecretAccessKey() {
        return this.plugin.getAwsSecretAccessKey();
    }

    public String getJenkinsUrl() {
        Jenkins jenkins = Jenkins.get();
        String url = jenkins.getRootUrl();
        if (url != null && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

