/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam.util;

import hudson.FilePath;
import io.jenkins.plugins.restlistparam.Messages;
import io.jenkins.plugins.restlistparam.RestListParameterGlobalConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.OkHttpClient;

public class OkHttpUtils {
    private static final Logger log = Logger.getLogger(OkHttpUtils.class.getName());
    private static final Jenkins jenkins = Jenkins.getInstanceOrNull();
    private static final String PARAMETERS = "parameters";
    private static final String PARAMETER_ID = "restListParam";
    private static final long MEBIBYTE = 0x100000L;

    private OkHttpUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static OkHttpClient getClientWithProxyAndCache(String httpEndpoint) {
        try {
            if (jenkins != null) {
                RestListParameterGlobalConfig config = RestListParameterGlobalConfig.get();
                FilePath parameterUserContent = jenkins.getRootPath().child(PARAMETERS).child(PARAMETER_ID);
                if (!parameterUserContent.exists() && !parameterUserContent.isDirectory()) {
                    parameterUserContent.mkdirs();
                }
                File cacheDir = new File(parameterUserContent.toURI().getPath(), "okhttp_cache");
                log.fine(Messages.PLP_OkHttpUtils_fine_CacheCreationSuccess(config.getCacheSize()));
                return new OkHttpClient.Builder().cache(new Cache(cacheDir, config.getCacheSize() * 0x100000L)).proxy(OkHttpUtils.getProxy(httpEndpoint)).build();
            }
            log.fine(Messages.PLP_OkHttpUtils_fine_NoJenkinsInstance());
        }
        catch (Exception ex) {
            log.warning(Messages.PLP_OkHttpUtils_warn_CacheIOException());
            log.fine("Cache creation failed with: " + ex.getClass().getName() + '\n' + "EX Message: " + ex.getMessage());
        }
        return new OkHttpClient.Builder().proxy(OkHttpUtils.getProxy(httpEndpoint)).build();
    }

    private static Proxy getProxy(String httpEndpoint) {
        if (jenkins == null || OkHttpUtils.jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        try {
            return OkHttpUtils.jenkins.proxy.createProxy(new URL(httpEndpoint).getHost());
        }
        catch (MalformedURLException e) {
            return OkHttpUtils.jenkins.proxy.createProxy(httpEndpoint);
        }
    }

    public static CacheControl getCacheControl(Integer minutesCached) {
        return new CacheControl.Builder().maxAge(minutesCached.intValue(), TimeUnit.MINUTES).build();
    }
}

