/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam.logic;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.jenkins.plugins.restlistparam.Messages;
import io.jenkins.plugins.restlistparam.model.MimeType;
import io.jenkins.plugins.restlistparam.model.ResultContainer;
import io.jenkins.plugins.restlistparam.model.ValueItem;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ValueResolver {
    private static final Logger log = Logger.getLogger(ValueResolver.class.getName());

    private ValueResolver() {
        throw new IllegalStateException("Static Logic class");
    }

    public static ResultContainer<List<ValueItem>> resolveXPath(String xmlStr, String expression, String displayExpression) {
        ResultContainer<List<ValueItem>> container = new ResultContainer<List<ValueItem>>(Collections.emptyList());
        if (!displayExpression.isEmpty()) {
            log.warning(Messages.RLP_ValueResolver_warn_xPath_DisplayExpression());
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlStr)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(expression, xmlDocument, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                container.setValue(ValueResolver.xmlNodeListToList(nodeList));
            } else {
                log.warning(Messages.RLP_ValueResolver_warn_xPath_NoValues());
                log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_xPath_NoValues(), expression, xmlStr));
                container.setErrorMsg(Messages.RLP_ValueResolver_warn_xPath_NoValues());
            }
        }
        catch (IllegalArgumentException | XPathExpressionException ignore) {
            log.warning(Messages.RLP_ValueResolver_warn_xPath_ExpressionErr());
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_xPath_ExpressionErr(), expression, xmlStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_xPath_ExpressionErr());
        }
        catch (SAXParseException ignore) {
            log.warning(Messages.RLP_ValueResolver_warn_xPath_MalformedXml());
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_xPath_MalformedXml(), expression, xmlStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_xPath_MalformedXml());
        }
        catch (Exception ex) {
            log.warning(Messages.RLP_ValueResolver_warn_xPath_ParserInit(ex.getClass().getName()));
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_xPath_ParserInit(ex.getClass().getName()), expression, xmlStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_xPath_ParserInit(ex.getClass().getName()));
        }
        return container;
    }

    private static List<ValueItem> xmlNodeListToList(NodeList nodeList) {
        ArrayList<ValueItem> res = new ArrayList<ValueItem>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            res.add(new ValueItem(nodeList.item(i).getTextContent(), nodeList.item(i).getTextContent()));
        }
        return res;
    }

    public static ResultContainer<List<ValueItem>> resolveJsonPath(String jsonStr, String expression, String displayExpression) {
        ResultContainer<List<ValueItem>> container = new ResultContainer<List<ValueItem>>(Collections.emptyList());
        try {
            List resolved = (List)JsonPath.parse((String)jsonStr).read(expression, new Predicate[0]);
            if (!resolved.isEmpty()) {
                container.setValue(resolved.stream().map(JsonPath::parse).map(context -> context.read("$", new Predicate[0])).map(ValueResolver::convertToString).map(value -> new ValueItem((String)value, ValueResolver.parseDisplayValue(value, displayExpression))).collect(Collectors.toList()));
            } else {
                log.warning(Messages.RLP_ValueResolver_warn_jPath_NoValues());
                log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_jPath_NoValues(), expression, jsonStr));
                container.setErrorMsg(Messages.RLP_ValueResolver_warn_jPath_NoValues());
            }
        }
        catch (PathNotFoundException ignored) {
            log.warning(Messages.RLP_ValueResolver_warn_jPath_NoValues());
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_jPath_NoValues(), expression, jsonStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_jPath_NoValues());
        }
        catch (InvalidPathException ignored) {
            log.warning(Messages.RLP_ValueResolver_warn_jPath_ExpressionErr());
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_jPath_ExpressionErr(), expression, jsonStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_jPath_ExpressionErr());
        }
        catch (InvalidJsonException ignored) {
            log.warning(Messages.RLP_ValueResolver_warn_jPath_MalformedJson());
            log.fine(ValueResolver.buildFineLogMsg(Messages.RLP_ValueResolver_warn_jPath_MalformedJson(), expression, jsonStr));
            container.setErrorMsg(Messages.RLP_ValueResolver_warn_jPath_MalformedJson());
        }
        return container;
    }

    public static String convertToString(Object obj) {
        if (obj instanceof Map) {
            return JsonPath.parse((Object)obj).jsonString();
        }
        if (obj instanceof Integer) {
            return Integer.toString((Integer)obj);
        }
        if (obj instanceof Float) {
            return Float.toString(((Float)obj).floatValue());
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new ClassCastException("Unable to cast '" + obj.getClass().getCanonicalName() + "' to String");
    }

    public static String parseDisplayValue(MimeType mime, String valueStr, String displayExpression) {
        if (mime == MimeType.APPLICATION_JSON) {
            return ValueResolver.parseDisplayValue(valueStr, displayExpression);
        }
        if (!displayExpression.isEmpty()) {
            log.warning(Messages.RLP_ValueResolver_warn_xPath_DisplayExpression());
        }
        return valueStr;
    }

    private static String parseDisplayValue(String jsonStr, String displayExpression) {
        return (String)JsonPath.parse((String)jsonStr).read(displayExpression, String.class, new Predicate[0]);
    }

    private static String buildFineLogMsg(String errorMsg, String expression, String valueString) {
        return "ERROR: " + errorMsg + "\nExpression: '" + expression + "'\nValueString: \n" + valueString + "\n";
    }
}

