/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SourceDirectoryFilter {
    private static final PathUtil PATH_UTIL = new PathUtil();

    public Set<String> getPermittedSourceDirectories(String workspacePath, Set<String> allowedSourceDirectories, Set<String> requestedSourceDirectories, FilteredLog log) {
        String normalizedWorkspacePath = PATH_UTIL.getAbsolutePath(workspacePath);
        HashSet<String> filteredDirectories = new HashSet<String>();
        for (String sourceDirectory : requestedSourceDirectories) {
            if (!this.isValidDirectory(sourceDirectory)) continue;
            if (PATH_UTIL.isAbsolute(sourceDirectory)) {
                this.verifyAbsoluteDirectory(normalizedWorkspacePath, allowedSourceDirectories, filteredDirectories, PATH_UTIL.getAbsolutePath(sourceDirectory), log);
                continue;
            }
            filteredDirectories.addAll(this.findRelative(normalizedWorkspacePath, sourceDirectory, log));
        }
        return filteredDirectories;
    }

    private void verifyAbsoluteDirectory(String workspacePath, Set<String> allowedSourceDirectories, Set<String> filteredDirectories, String sourceDirectory, FilteredLog log) {
        String normalizedSourceDirectory = PATH_UTIL.getAbsolutePath(sourceDirectory);
        if (normalizedSourceDirectory.equals(workspacePath)) {
            return;
        }
        if (normalizedSourceDirectory.startsWith(workspacePath)) {
            filteredDirectories.add(PATH_UTIL.getRelativePath(workspacePath, normalizedSourceDirectory));
        } else if (allowedSourceDirectories.contains(normalizedSourceDirectory)) {
            filteredDirectories.add(normalizedSourceDirectory);
        } else {
            log.logError("Removing non-workspace source directory '%s' - it has not been approved in Jenkins' global configuration.", new Object[]{normalizedSourceDirectory});
        }
    }

    private boolean isValidDirectory(String sourceDirectory) {
        return StringUtils.isNotBlank((CharSequence)sourceDirectory) && !"-".equals(sourceDirectory);
    }

    private List<String> findRelative(String directory, String pattern, FilteredLog log) {
        if (!pattern.startsWith("glob:") && !pattern.startsWith("regex:")) {
            return List.of(PATH_UTIL.createAbsolutePath(directory, pattern));
        }
        try {
            PathMatcherFileVisitor visitor = new PathMatcherFileVisitor(pattern);
            Files.walkFileTree(Paths.get(directory, new String[0]), visitor);
            return visitor.getMatches();
        }
        catch (IllegalArgumentException exception) {
            log.logException((Exception)exception, "Pattern not valid for FileSystem.getPathMatcher: '%s'", new Object[]{pattern});
        }
        catch (IOException exception) {
            log.logException((Exception)exception, "Cannot find subdirectories in '%s' for glob: pattern '%s'", new Object[]{directory, pattern});
        }
        return new ArrayList<String>();
    }

    private static class PathMatcherFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PathMatcher pathMatcher;
        private final List<String> matches = new ArrayList<String>();

        PathMatcherFileVisitor(String syntaxAndPattern) {
            this.pathMatcher = FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
        }

        List<String> getMatches() {
            return this.matches;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (this.pathMatcher.matches(dir)) {
                this.matches.add(PATH_UTIL.getAbsolutePath(dir));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

