/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SourceDirectoryFilter {
    public Set<String> getPermittedSourceDirectories(String workspacePath, Set<String> allowedSourceDirectories, Set<String> requestedSourceDirectories, FilteredLog log) {
        PathUtil pathUtil = new PathUtil();
        HashSet<String> filteredDirectories = new HashSet<String>();
        for (String sourceDirectory : requestedSourceDirectories) {
            if (!StringUtils.isNotBlank((CharSequence)sourceDirectory) || "-".equals(sourceDirectory)) continue;
            if (pathUtil.isAbsolute(sourceDirectory)) {
                String normalized = pathUtil.getAbsolutePath(sourceDirectory);
                if (allowedSourceDirectories.contains(normalized)) {
                    filteredDirectories.add(normalized);
                    continue;
                }
                log.logError("Removing source directory '%s' - it has not been approved in Jenkins' global configuration.", new Object[]{normalized});
                continue;
            }
            filteredDirectories.add(pathUtil.createAbsolutePath(workspacePath, sourceDirectory));
        }
        return filteredDirectories;
    }
}

