/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import hudson.util.ListBoxModel;

public enum PrismTheme {
    PRISM("Default", "prism.css"),
    COY("Coy", "prism-coy.css"),
    DARK("Dark", "prism-dark.css"),
    FUNKY("Funky", "prism-funky.css"),
    OKAIDIA("Okaidia", "prism-okaidia.css"),
    SOLARIZED_LIGHT("Solarized Light", "prism-solarizedlight.css"),
    TOMORROW_NIGHT("Tomorrow Night", "prism-tomorrow.css"),
    TWILIGHT("Twilight", "prism-twilight.css");

    private final String displayName;
    private final String fileName;

    private PrismTheme(String displayName, String fileName) {
        this.displayName = displayName;
        this.fileName = fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static ListBoxModel getAllDisplayNames() {
        ListBoxModel model = new ListBoxModel();
        for (PrismTheme theme : PrismTheme.values()) {
            model.add(theme.getDisplayName(), theme.name());
        }
        return model;
    }
}

