/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import hudson.FilePath;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class FilePermissionEnforcer {
    private static final PathUtil PATH_UTIL = new PathUtil();

    public boolean isInWorkspace(String fileName, FilePath workspace, String ... permittedDirectories) {
        return this.isInWorkspace(fileName, workspace, new HashSet<String>(Arrays.asList(permittedDirectories)));
    }

    public boolean isInWorkspace(String fileName, FilePath workspace, Set<String> permittedDirectories) {
        String sourceFile = PATH_UTIL.getAbsolutePath(fileName);
        Set permittedAbsolutePaths = permittedDirectories.stream().map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
        permittedAbsolutePaths.add(workspace.getRemote());
        return permittedAbsolutePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).anyMatch(prefix -> Paths.get(sourceFile, new String[0]).startsWith((Path)prefix));
    }
}

