/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class SecureXmlParserFactory {
    private static final String SAX_FEATURE_PREFIX = "http://xml.org/sax/features/";
    private static final String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "external-parameter-entities";
    private static final String RESOLVE_DTD_URIS_FEATURE = "resolve-dtd-uris";
    private static final String USE_ENTITY_RESOLVER2_FEATURE = "use-entity-resolver2";
    private static final String CREATE_ENTITY_REF_NODES_FEATURE = "dom/create-entity-ref-nodes";
    private static final String LOAD_DTD_GRAMMAR_FEATURE = "nonvalidating/load-dtd-grammar";
    private static final String LOAD_EXTERNAL_DTD_FEATURE = "nonvalidating/load-external-dtd";
    private static final String[] ENABLED_PROPERTIES = new String[]{"http://javax.xml.XMLConstants/feature/secure-processing"};
    private static final String[] DISABLED_PROPERTIES = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/resolve-dtd-uris", "http://xml.org/sax/features/use-entity-resolver2", "http://apache.org/xml/features/dom/create-entity-ref-nodes", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/nonvalidating/load-external-dtd"};
    private static final String[] DISABLED_ATTRIBUTES = new String[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", "http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalStylesheet"};
    private static final String CLEAR_ATTRIBUTE = "";
    private static final String SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";

    public DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.setFeatures(factory);
            this.clearAttributes(factory);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            throw new IllegalArgumentException("Can't create instance of DocumentBuilder", exception);
        }
    }

    @VisibleForTesting
    DocumentBuilderFactory createDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    private void setFeatures(DocumentBuilderFactory factory) {
        for (String enabledProperty : ENABLED_PROPERTIES) {
            this.setFeature(factory, enabledProperty, true);
        }
        for (String disabledProperty : DISABLED_PROPERTIES) {
            this.setFeature(factory, disabledProperty, false);
        }
    }

    private void setFeature(DocumentBuilderFactory factory, String enabledProperty, boolean value) {
        try {
            factory.setFeature(enabledProperty, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private void clearAttributes(DocumentBuilderFactory factory) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                factory.setAttribute(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void clearAttributes(TransformerFactory transformerFactory) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                transformerFactory.setAttribute(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public SAXParser createSaxParser() {
        try {
            SAXParserFactory factory = this.createSaxParserFactory();
            this.configureSaxParserFactory(factory);
            SAXParser parser = factory.newSAXParser();
            this.secureParser(parser);
            return parser;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IllegalArgumentException("Can't create instance of SAXParser", exception);
        }
    }

    @VisibleForTesting
    SAXParserFactory createSaxParserFactory() {
        return SAXParserFactory.newInstance();
    }

    private void secureParser(SAXParser parser) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                parser.setProperty(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
    }

    public void configureSaxParserFactory(SAXParserFactory factory) {
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        for (String enabledProperty : ENABLED_PROPERTIES) {
            try {
                factory.setFeature(enabledProperty, true);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        for (String disabledProperty : DISABLED_PROPERTIES) {
            try {
                factory.setFeature(disabledProperty, false);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
    }

    @SuppressFBWarnings(value={"XXE_XMLSTREAMREADER"}, justification="The reader is secured in the called method")
    public XMLStreamReader createXmlStreamReader(Reader reader) {
        try {
            return this.createSecureInputFactory().createXMLStreamReader(reader);
        }
        catch (XMLStreamException exception) {
            throw new IllegalArgumentException("Can't create instance of XMLStreamReader", exception);
        }
    }

    @SuppressFBWarnings(value={"XXE_XMLSTREAMREADER"}, justification="The reader is secured in the called method")
    public XMLEventReader createXmlEventReader(Reader reader) {
        try {
            return this.createSecureInputFactory().createXMLEventReader(reader);
        }
        catch (XMLStreamException exception) {
            throw new IllegalArgumentException("Can't create instance of XMLEventReader", exception);
        }
    }

    private XMLInputFactory createSecureInputFactory() {
        XMLInputFactory factory = this.createXmlInputFactory();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty(SUPPORTING_EXTERNAL_ENTITIES, false);
        return factory;
    }

    @VisibleForTesting
    XMLInputFactory createXmlInputFactory() {
        return XMLInputFactory.newInstance();
    }

    @SuppressFBWarnings(value={"XXE_SAXPARSER"}, justification="The parser is secured in the called method")
    public void parse(Reader reader, Charset charset, DefaultHandler handler) {
        try {
            this.createSaxParser().parse(this.createInputSource(reader, charset), handler);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="The parser is secured in the called method")
    public Document readDocument(Reader reader, Charset charset) {
        try {
            return this.createDocumentBuilder().parse(this.createInputSource(reader, charset));
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private InputSource createInputSource(Reader reader, Charset charset) throws IOException {
        ReaderInputStream inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).setCharset(charset).get();
        return new InputSource((InputStream)inputStream);
    }

    @SuppressFBWarnings(value={"XXE_DTD_TRANSFORM_FACTORY", "XXE_XSLT_TRANSFORM_FACTORY"}, justification="The transformer is secured in the called method")
    public Transformer createTransformer() {
        try {
            TransformerFactory transformerFactory = this.createTransformerFactory();
            this.clearAttributes(transformerFactory);
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException exception) {
            throw new IllegalArgumentException("Can't create instance of Transformer", exception);
        }
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"XXE_DTD_TRANSFORM_FACTORY", "XXE_XSLT_TRANSFORM_FACTORY"}, justification="The transformer is secured in the called method")
    TransformerFactory createTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    public static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = -9016364685084958944L;

        public ParsingException(Throwable cause) {
            super(ParsingException.createMessage(cause, "Exception occurred during parsing"), cause);
        }

        @FormatMethod
        public ParsingException(String messageFormat, Object ... args) {
            super(String.format(messageFormat, args));
        }

        @FormatMethod
        public ParsingException(Throwable cause, String messageFormat, Object ... args) {
            super(ParsingException.createMessage(cause, String.format(messageFormat, args)), cause);
        }

        private static String createMessage(Throwable cause, String message) {
            return String.format("%s%n%s%n%s", message, ExceptionUtils.getMessage((Throwable)cause), ExceptionUtils.getStackTrace((Throwable)cause));
        }
    }
}

