/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FilteredLog
implements Serializable {
    private static final long serialVersionUID = -8552323621953159904L;
    private static final int DEFAULT_MAX_LINES = 20;
    private final String title;
    private final int maxLines;
    private int lines = 0;
    private final List<String> infoMessages = new ArrayList<String>();
    private final List<String> errorMessages = new ArrayList<String>();
    private transient ReentrantLock lock = new ReentrantLock();

    public FilteredLog() {
        this("", 20);
    }

    public FilteredLog(String title) {
        this(title, 20);
    }

    public FilteredLog(String title, int maxLines) {
        this.title = title;
        this.maxLines = maxLines;
    }

    protected Object readResolve() {
        this.lock = new ReentrantLock();
        return this;
    }

    public void logInfo(String message) {
        this.lock.lock();
        try {
            this.infoMessages.add(message);
        }
        finally {
            this.lock.unlock();
        }
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.logInfo(String.format(format, args));
    }

    public void logError(String message) {
        this.lock.lock();
        try {
            if (this.lines < this.maxLines) {
                if (StringUtils.isNotBlank((CharSequence)this.title) && this.errorMessages.isEmpty()) {
                    this.errorMessages.add(this.title);
                }
                this.errorMessages.add(message);
            }
            ++this.lines;
        }
        finally {
            this.lock.unlock();
        }
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.logError(String.format(format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.logError(format, args);
        this.lock.lock();
        try {
            this.errorMessages.addAll(Arrays.asList(ExceptionUtils.getRootCauseStackTrace((Throwable)exception)));
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.lines;
    }

    @Deprecated
    public void logSummary() {
    }

    public List<String> getInfoMessages() {
        this.lock.lock();
        try {
            List<String> list = List.copyOf(this.infoMessages);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<String> getErrorMessages() {
        this.lock.lock();
        try {
            ArrayList<String> messages = new ArrayList<String>();
            if (this.errorMessages.isEmpty()) {
                ArrayList<String> arrayList = messages;
                return arrayList;
            }
            messages.addAll(this.errorMessages);
            if (this.lines > this.maxLines) {
                messages.add(String.format("  ... skipped logging of %d additional errors ...", this.lines - this.maxLines));
            }
            ArrayList<String> arrayList = messages;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasErrors() {
        this.lock.lock();
        try {
            boolean bl = !this.errorMessages.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void merge(FilteredLog other) {
        this.lock.lock();
        try {
            this.infoMessages.addAll(other.getInfoMessages());
            this.errorMessages.addAll(other.getErrorMessages());
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredLog log = (FilteredLog)o;
        if (this.maxLines != log.maxLines) {
            return false;
        }
        if (this.lines != log.lines) {
            return false;
        }
        if (!Objects.equals(this.title, log.title)) {
            return false;
        }
        if (!this.infoMessages.equals(log.infoMessages)) {
            return false;
        }
        return this.errorMessages.equals(log.errorMessages);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + this.maxLines;
        result = 31 * result + this.lines;
        result = 31 * result + this.infoMessages.hashCode();
        result = 31 * result + this.errorMessages.hashCode();
        return result;
    }
}

