// CHECKSTYLE:OFF

package io.jenkins.plugins.util;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code QualityGate.Failure}: {@code Fail the step if the quality
     * gate has been missed}.
     * 
     * @return
     *     {@code Fail the step if the quality gate has been missed}
     */
    public static String QualityGate_Failure() {
        return holder.format("QualityGate.Failure");
    }

    /**
     * Key {@code QualityGate.Failure}: {@code Fail the step if the quality
     * gate has been missed}.
     * 
     * @return
     *     {@code Fail the step if the quality gate has been missed}
     */
    public static Localizable _QualityGate_Failure() {
        return new Localizable(holder, "QualityGate.Failure");
    }

    /**
     * Key {@code QualityGate.Unstable}: {@code Set the build status to
     * unstable if the quality gate has been missed}.
     * 
     * @return
     *     {@code Set the build status to unstable if the quality gate has been
     *     missed}
     */
    public static String QualityGate_Unstable() {
        return holder.format("QualityGate.Unstable");
    }

    /**
     * Key {@code QualityGate.Unstable}: {@code Set the build status to
     * unstable if the quality gate has been missed}.
     * 
     * @return
     *     {@code Set the build status to unstable if the quality gate has been
     *     missed}
     */
    public static Localizable _QualityGate_Unstable() {
        return new Localizable(holder, "QualityGate.Unstable");
    }

    /**
     * Key {@code FieldValidator.Error.WrongIdFormat}: {@code An ID must
     * match the regexp pattern {0}, but {1} does not.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An ID must match the regexp pattern {0}, but {1} does not.}
     */
    public static String FieldValidator_Error_WrongIdFormat(Object arg0, Object arg1) {
        return holder.format("FieldValidator.Error.WrongIdFormat", arg0, arg1);
    }

    /**
     * Key {@code FieldValidator.Error.WrongIdFormat}: {@code An ID must
     * match the regexp pattern {0}, but {1} does not.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An ID must match the regexp pattern {0}, but {1} does not.}
     */
    public static Localizable _FieldValidator_Error_WrongIdFormat(Object arg0, Object arg1) {
        return new Localizable(holder, "FieldValidator.Error.WrongIdFormat", arg0, arg1);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static String FieldValidator_Error_DefaultEncoding(Object arg0) {
        return holder.format("FieldValidator.Error.DefaultEncoding", arg0);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static Localizable _FieldValidator_Error_DefaultEncoding(Object arg0) {
        return new Localizable(holder, "FieldValidator.Error.DefaultEncoding", arg0);
    }

}
