/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Result;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public enum QualityGateStatus {
    INACTIVE(Result.NOT_BUILT),
    PASSED(Result.SUCCESS),
    WARNING(Result.UNSTABLE),
    FAILED(Result.FAILURE);

    private final Result result;

    private QualityGateStatus(Result result) {
        this.result = result;
    }

    public String getIconClass() {
        return this.result.color.getIconClassName();
    }

    public String getDescription() {
        return this.result.color.getDescription();
    }

    @Whitelisted
    public boolean isSuccessful() {
        return this == PASSED || this == INACTIVE;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean isWorseThan(QualityGateStatus other) {
        return this.ordinal() > other.ordinal();
    }
}

