/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.util.Messages;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtilities {
    private static final Set<String> ALL_CHARSETS = Charset.availableCharsets().keySet();
    private static final Pattern VALID_ID_PATTERN = Pattern.compile("\\p{Alnum}[\\p{Alnum}-_.]*");

    public ComboBoxModel getAllCharsets() {
        return new ComboBoxModel(ALL_CHARSETS);
    }

    public Charset getCharset(@CheckForNull String charset) {
        try {
            if (StringUtils.isNotBlank((CharSequence)charset)) {
                return Charset.forName(charset);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    public FormValidation validateCharset(String reportEncoding) {
        try {
            if (StringUtils.isBlank((CharSequence)reportEncoding) || Charset.isSupported(reportEncoding)) {
                return FormValidation.ok();
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return FormValidation.errorWithMarkup((String)ValidationUtilities.createWrongEncodingErrorMessage());
    }

    @VisibleForTesting
    static String createWrongEncodingErrorMessage() {
        return Messages.FieldValidator_Error_DefaultEncoding("https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/nio/charset/Charset.html");
    }

    public void ensureValidId(String id) {
        if (!this.isValidId(id)) {
            throw new IllegalArgumentException(ValidationUtilities.createInvalidIdMessage(id));
        }
    }

    public FormValidation validateId(String id) {
        if (this.isValidId(id)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)ValidationUtilities.createInvalidIdMessage(id));
    }

    private boolean isValidId(String id) {
        return StringUtils.isEmpty((CharSequence)id) || VALID_ID_PATTERN.matcher(id).matches();
    }

    static String createInvalidIdMessage(String id) {
        return Messages.FieldValidator_Error_WrongIdFormat(VALID_ID_PATTERN.pattern(), id);
    }

    public FormValidation doCheckPattern(AbstractProject<?, ?> project, String pattern) {
        if (project != null) {
            try {
                FilePath workspace = project.getSomeWorkspace();
                if (workspace != null && workspace.exists()) {
                    return this.validatePatternInWorkspace(pattern, workspace);
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return FormValidation.ok();
    }

    private FormValidation validatePatternInWorkspace(String pattern, FilePath workspace) throws IOException, InterruptedException {
        String result = workspace.validateAntFileMask(pattern, FilePath.VALIDATE_ANT_FILE_MASK_BOUND);
        if (result != null) {
            return FormValidation.error((String)result);
        }
        return FormValidation.ok();
    }
}

