/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.util.Collection;

public class PluginLogger {
    private final String pluginName;
    private final PrintStream delegate;

    public PluginLogger(PrintStream logger, String pluginName) {
        this.pluginName = pluginName.contains("[") ? pluginName + " " : String.format("[%s] ", pluginName);
        this.delegate = logger;
    }

    @FormatMethod
    public void log(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    public void logEachLine(Collection<String> lines) {
        lines.forEach(this::print);
    }

    private void print(String line) {
        this.delegate.println(this.pluginName + line);
    }
}

