/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceExtractor {
    private final boolean readingFromJarFile;
    private final Extractor extractor;
    private final String resourcePath;

    public ResourceExtractor(Class<?> targetClass) {
        this(targetClass, targetClass.getProtectionDomain());
    }

    @VisibleForTesting
    ResourceExtractor(Class<?> targetClass, ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            throw new IllegalArgumentException("There is no CodeSource for " + targetClass);
        }
        URL location = codeSource.getLocation();
        if (location == null) {
            throw new IllegalArgumentException("There is no CodeSource location for " + targetClass);
        }
        String locationPath = location.getPath();
        if (StringUtils.isBlank((CharSequence)locationPath)) {
            throw new IllegalArgumentException("The CodeSource location path is not set for " + targetClass);
        }
        Path entryPoint = new File(locationPath).toPath();
        this.readingFromJarFile = Files.isRegularFile(entryPoint, new LinkOption[0]);
        this.extractor = this.readingFromJarFile ? new JarExtractor(entryPoint) : new FolderExtractor(entryPoint);
        this.resourcePath = entryPoint.toString();
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isReadingFromJarFile() {
        return this.readingFromJarFile;
    }

    public void extract(Path targetDirectory, String source, String ... sources) {
        if (!Files.isDirectory(targetDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Target directory must be an existing directory: " + targetDirectory);
        }
        String[] allSources = Arrays.copyOf(sources, sources.length + 1);
        allSources[sources.length] = source;
        this.extractor.extractFiles(targetDirectory, allSources);
    }

    private static class JarExtractor
    extends Extractor {
        JarExtractor(Path entryPoint) {
            super(entryPoint);
        }

        @Override
        public void extractFiles(Path targetDirectory, String ... sources) {
            Set remaining = Arrays.stream(sources).collect(Collectors.toSet());
            try (JarFile jar = new JarFile(this.getEntryPoint().toFile());){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!remaining.contains(name)) continue;
                    this.copy(targetDirectory, jar, entry, name);
                    remaining.remove(name);
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
            if (!remaining.isEmpty()) {
                throw new NoSuchElementException("The following files have not been found: " + remaining);
            }
        }

        private void copy(Path targetDirectory, JarFile jar, JarEntry entry, String name) throws IOException {
            Path targetFile = targetDirectory.resolve(name);
            if (!targetFile.normalize().startsWith(targetDirectory)) {
                throw new IllegalArgumentException("Corrupt jar structure, contains invalid path: " + name);
            }
            Path parent = targetFile.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (InputStream inputStream = jar.getInputStream(entry);
                 OutputStream outputStream = Files.newOutputStream(targetFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
    }

    private static abstract class Extractor {
        private final Path entryPoint;

        Extractor(Path entryPoint) {
            this.entryPoint = entryPoint;
        }

        Path getEntryPoint() {
            return this.entryPoint;
        }

        abstract void extractFiles(Path var1, String ... var2);
    }

    private static class FolderExtractor
    extends Extractor {
        FolderExtractor(Path entryPoint) {
            super(entryPoint);
        }

        @Override
        public void extractFiles(Path targetDirectory, String ... sources) {
            try {
                for (String source : sources) {
                    Path targetFile = targetDirectory.resolve(source);
                    Files.createDirectories(targetFile, new FileAttribute[0]);
                    this.copy(targetFile, source);
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void copy(Path target, String source) {
            try {
                Files.copy(this.getEntryPoint().resolve(source), target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
    }
}

