/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class QualityGateEvaluator<T extends QualityGate> {
    private final List<T> qualityGates = new ArrayList<T>();

    protected QualityGateEvaluator(Collection<? extends T> qualityGates) {
        this.qualityGates.addAll(qualityGates);
    }

    public QualityGateResult evaluate() {
        if (this.qualityGates.isEmpty()) {
            return new QualityGateResult();
        }
        QualityGateResult result = new QualityGateResult();
        for (QualityGate qualityGate : this.qualityGates) {
            this.evaluate(qualityGate, result);
        }
        return result;
    }

    protected abstract void evaluate(T var1, QualityGateResult var2);

    public void addAll(Collection<? extends T> additionalQualityGates) {
        this.qualityGates.addAll(additionalQualityGates);
    }

    public boolean isEnabled() {
        return !this.qualityGates.isEmpty();
    }
}

