/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.TreeString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TreeStringBuilder {
    private Child root = new Child(new TreeString());
    private static final Map<String, Child> NO_CHILDREN = Collections.emptyMap();

    public TreeString intern(String string) {
        return this.getRoot().intern(string).getNode();
    }

    public TreeString intern(TreeString treeString) {
        return this.getRoot().intern(treeString.toString()).getNode();
    }

    public void dedup() {
        this.getRoot().dedup(new HashMap<String, char[]>());
    }

    Child getRoot() {
        return this.root;
    }

    void setRoot(Child root) {
        this.root = root;
    }

    private static final class Child {
        private final TreeString node;
        private Map<String, Child> children = NO_CHILDREN;

        Child(TreeString node) {
            this.node = node;
        }

        public Child intern(String string) {
            if (string.isEmpty()) {
                return this;
            }
            this.makeWritable();
            for (Map.Entry<String, Child> entry : this.children.entrySet()) {
                int plen = this.commonPrefix(entry.getKey(), string);
                if (plen <= 0) continue;
                if (plen < entry.getKey().length()) {
                    Child child = entry.getValue();
                    String prefix = string.substring(0, plen);
                    Child middle = child.split(prefix);
                    this.children.remove(entry.getKey());
                    this.children.put(prefix, middle);
                    return middle.intern(string.substring(plen));
                }
                return entry.getValue().intern(string.substring(plen));
            }
            Child t = this.children.get(string);
            if (t == null) {
                t = new Child(new TreeString(this.getNode(), string));
                this.children.put(string, t);
            }
            return t;
        }

        private void makeWritable() {
            if (this.children == NO_CHILDREN) {
                this.children = new HashMap<String, Child>();
            }
        }

        private Child split(String prefix) {
            String suffix = this.getNode().getLabel().substring(prefix.length());
            Child middle = new Child(this.getNode().split(prefix));
            middle.makeWritable();
            middle.children.put(suffix, this);
            return middle;
        }

        private int commonPrefix(String a, String b) {
            int m = Math.min(a.length(), b.length());
            for (int i = 0; i < m; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return i;
            }
            return m;
        }

        private void dedup(Map<String, char[]> table) {
            this.getNode().dedup(table);
            for (Child child : this.children.values()) {
                child.dedup(table);
            }
        }

        TreeString getNode() {
            return this.node;
        }
    }
}

