/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.util.Generated;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FilteredLog
implements Serializable {
    private static final long serialVersionUID = -8552323621953159904L;
    private static final int DEFAULT_MAX_LINES = 20;
    private final String title;
    private final int maxLines;
    private int lines = 0;
    private final List<String> infoMessages = new ArrayList<String>();
    private final List<String> errorMessages = new ArrayList<String>();

    public FilteredLog(String title) {
        this(title, 20);
    }

    public FilteredLog(String title, int maxLines) {
        this.title = title;
        this.maxLines = maxLines;
    }

    public void logInfo(String message) {
        this.infoMessages.add(message);
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.errorMessages.add(String.format(format, args));
        }
        ++this.lines;
    }

    private void printTitle() {
        if (this.lines == 0) {
            this.errorMessages.add(this.title);
        }
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.errorMessages.add(String.format(format, args));
            this.errorMessages.addAll(Arrays.asList(ExceptionUtils.getRootCauseStackTrace((Throwable)exception)));
        }
        ++this.lines;
    }

    public int size() {
        return this.lines;
    }

    public void logSummary() {
        if (this.lines > this.maxLines) {
            this.errorMessages.add(String.format("  ... skipped logging of %d additional errors ...", this.lines - this.maxLines));
        }
    }

    public List<String> getInfoMessages() {
        return Collections.unmodifiableList(this.infoMessages);
    }

    public List<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public void merge(FilteredLog other) {
        this.infoMessages.addAll(other.infoMessages);
        this.errorMessages.addAll(other.errorMessages);
    }

    @Generated
    public boolean equals(@CheckForNull Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredLog that = (FilteredLog)o;
        return this.maxLines == that.maxLines && this.lines == that.lines && this.title.equals(that.title) && this.infoMessages.equals(that.infoMessages) && this.errorMessages.equals(that.errorMessages);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.title, this.maxLines, this.lines, this.infoMessages, this.errorMessages);
    }

    @Generated
    public String toString() {
        return "FilteredLog{title='" + this.title + "', maxLines=" + this.maxLines + ", lines=" + this.lines + ", infoMessages=" + this.infoMessages + ", errorMessages=" + this.errorMessages + "}";
    }
}

