/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Descriptor;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.Objects;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class QualityGateAssert
extends AbstractObjectAssert<QualityGateAssert, QualityGate> {
    public QualityGateAssert(QualityGate actual) {
        super((Object)actual, QualityGateAssert.class);
    }

    @CheckReturnValue
    public static QualityGateAssert assertThat(QualityGate actual) {
        return new QualityGateAssert(actual);
    }

    public QualityGateAssert hasCriticality(QualityGate.QualityGateCriticality criticality) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting criticality of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        QualityGate.QualityGateCriticality actualCriticality = ((QualityGate)this.actual).getCriticality();
        if (!Objects.deepEquals(actualCriticality, criticality)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, criticality, actualCriticality});
        }
        return this;
    }

    public QualityGateAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Descriptor actualDescriptor = ((QualityGate)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public QualityGateAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((QualityGate)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public QualityGateAssert hasStatus(QualityGateStatus status) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        QualityGateStatus actualStatus = ((QualityGate)this.actual).getStatus();
        if (!Objects.deepEquals(actualStatus, status)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, status, actualStatus});
        }
        return this;
    }

    public QualityGateAssert hasThreshold(double threshold) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting threshold of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        double actualThreshold = ((QualityGate)this.actual).getThreshold();
        if (actualThreshold != threshold) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, threshold, actualThreshold});
        }
        return this;
    }

    public QualityGateAssert hasThresholdCloseTo(double threshold, double assertjOffset) {
        this.isNotNull();
        double actualThreshold = ((QualityGate)this.actual).getThreshold();
        String assertjErrorMessage = String.format("\nExpecting threshold:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualThreshold, threshold, assertjOffset, Math.abs(threshold - actualThreshold));
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualThreshold).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(threshold, Assertions.within((Double)assertjOffset));
        return this;
    }
}

