/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.FilteredLog;
import hudson.model.TaskListener;
import io.jenkins.plugins.util.LogHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class LogHandlerTest {
    private static final String LOG_HANDLER_NAME = "TestHandler";
    private static final String MESSAGE = "TestMessage";
    private static final String NOT_SHOWN = "Not shown";
    private static final String ADDITIONAL_MESSAGE = "Additional";
    private static final String LOGGER_MESSAGE = "Logger message";

    LogHandlerTest() {
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest(name="Log some messages and evaluate quiet flag value (quiet = {0})")
    void shouldLogInfoAndErrorMessage(boolean quiet) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        TaskListener taskListener = this.createTaskListener(printStream);
        FilteredLog logger = new FilteredLog("Title");
        logger.logInfo(NOT_SHOWN);
        logger.logError(NOT_SHOWN, new Object[0]);
        LogHandler logHandler = new LogHandler(taskListener, LOG_HANDLER_NAME, logger);
        logHandler.setQuiet(quiet);
        logger.logInfo(MESSAGE);
        logger.logError(MESSAGE, new Object[0]);
        logHandler.log(logger);
        if (quiet) {
            Assertions.assertThat((String)outputStream.toString()).isEmpty();
        } else {
            Assertions.assertThat((String)outputStream.toString()).isEqualTo(String.format("[%s] [-ERROR-] %s%n[%s] %s%n", LOG_HANDLER_NAME, MESSAGE, LOG_HANDLER_NAME, MESSAGE));
        }
        logger.logInfo(ADDITIONAL_MESSAGE);
        logger.logError(ADDITIONAL_MESSAGE, new Object[0]);
        logHandler.log(logger);
        if (quiet) {
            Assertions.assertThat((String)outputStream.toString()).isEmpty();
        } else {
            Assertions.assertThat((String)outputStream.toString()).isEqualTo(String.format("[%s] [-ERROR-] %s%n[%s] %s%n[%s] [-ERROR-] %s%n[%s] %s%n", LOG_HANDLER_NAME, MESSAGE, LOG_HANDLER_NAME, MESSAGE, LOG_HANDLER_NAME, ADDITIONAL_MESSAGE, LOG_HANDLER_NAME, ADDITIONAL_MESSAGE));
        }
    }

    @Test
    void shouldLogFormattedMessage() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        TaskListener taskListener = this.createTaskListener(printStream);
        LogHandler logHandler = new LogHandler(taskListener, LOG_HANDLER_NAME);
        logHandler.log(LOGGER_MESSAGE, new Object[0]);
        Assertions.assertThat((String)outputStream.toString()).isEqualTo(String.format("[%s] %s%n", LOG_HANDLER_NAME, LOGGER_MESSAGE));
    }

    private TaskListener createTaskListener(PrintStream printStream) {
        TaskListener taskListener = (TaskListener)Mockito.mock(TaskListener.class);
        Mockito.when((Object)taskListener.getLogger()).thenReturn((Object)printStream);
        return taskListener;
    }
}

