/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.EnvVars;
import io.jenkins.plugins.util.EnvironmentResolver;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvironmentResolverTest {
    private static final int NUMBER_OF_CHARS = 1024;
    private static final String KEY = "KEY";
    private static final String VALUE = "VALUE";
    private static final String RESULT = "RESULT";

    EnvironmentResolverTest() {
    }

    @Test
    void shouldReturnUnmodifiedOutputForEmptyInput() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        String expanded = environmentResolver.expandEnvironmentVariables(new EnvVars(), "");
        Assertions.assertThat((String)expanded).isEmpty();
    }

    @Test
    void shouldReturnSameOutputAsInput() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        String expanded = environmentResolver.expandEnvironmentVariables(new EnvVars(), "TestString");
        Assertions.assertThat((String)expanded).isEqualTo("TestString");
    }

    @Test
    void shouldReturnSameOutputAsInputForAnEnvironmentWhichIsNull() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        String expanded = environmentResolver.expandEnvironmentVariables(null, "TestStringForNull");
        Assertions.assertThat((String)expanded).isEqualTo("TestStringForNull");
    }

    @Test
    void shouldReturnNonAdjustedOutputForDefinedInput() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String expected = "TestTesting";
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, expected);
        Assertions.assertThat((String)expanded).isEqualTo(expected);
    }

    @Test
    void shouldReturnAdjustedOutputForDefinedInput() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String previous = "$KEY";
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, previous);
        Assertions.assertThat((String)expanded).isEqualTo(VALUE);
    }

    @Test
    void shouldReplaceTheFirstKeyWithFirstValueAndThenReplaceFirstValueWithResult() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, "$VALUE");
        envVars.put(VALUE, RESULT);
        String previous = "$KEY";
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, previous);
        Assertions.assertThat((String)expanded).isEqualTo(RESULT);
    }

    @Test
    void shouldReturnAdjustedOutputForAGivenInputBasedOnDollarSigns() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String previous = "$$Test$$Testing$TestString$$Testing$Test";
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, previous);
        String expected = "$Test$Testing$TestString$Testing$Test";
        Assertions.assertThat((String)expanded).isEqualTo(expected);
    }

    @Test
    void shouldRunZeroTimesThroughTheLoopAndLeaveTheInputUnmodified() {
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String nonExpanded = "$";
        String expected = "$";
        this.checkLoopWithNumberOfRuns(0, envVars, nonExpanded, expected);
    }

    @Test
    void shouldRunOneTimeThroughTheLoopAndModifyTheInput() {
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String nonExpanded = "$$";
        String expected = "$";
        this.checkLoopWithNumberOfRuns(1, envVars, nonExpanded, expected);
    }

    @Test
    void shouldExitAfterSetRetriesHasExceededAndHenceLeaveTheInputUnmodified() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, this.createDollarString());
        Assertions.assertThat((String)expanded).isEqualTo("$");
    }

    @Test
    void shouldExitAfterSetRetriesHasExceededAndHenceLeaveTheInputUnmodifiedTestTheSecondShortCircuitCondition() {
        EnvironmentResolver environmentResolver = new EnvironmentResolver();
        EnvVars envVars = new EnvVars();
        envVars.put(KEY, VALUE);
        String expanded = environmentResolver.expandEnvironmentVariables(envVars, " ");
        Assertions.assertThat((String)expanded).isEqualTo(expanded);
    }

    private String createDollarString() {
        char[] chars = new char[1024];
        Arrays.fill(chars, '$');
        return new String(chars);
    }

    private void checkLoopWithNumberOfRuns(int resolveVariablesDepth, EnvVars environment, String nonExpanded, String expected) {
        EnvironmentResolver environmentResolver = new EnvironmentResolver(resolveVariablesDepth);
        String expanded = environmentResolver.expandEnvironmentVariables(environment, nonExpanded);
        Assertions.assertThat((String)expanded).isEqualTo(expected);
    }
}

