/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Action;
import hudson.model.Job;
import io.jenkins.plugins.util.BuildAction;
import java.io.IOException;
import java.util.Optional;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class JobAction<T extends BuildAction<?>>
implements Action {
    private final Job<?, ?> owner;
    private final Class<T> buildActionClass;

    protected JobAction(Job<?, ?> owner, Class<T> buildActionClass) {
        this.owner = owner;
        this.buildActionClass = buildActionClass;
    }

    public Job<?, ?> getOwner() {
        return this.owner;
    }

    protected Class<T> getBuildActionClass() {
        return this.buildActionClass;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        Optional<T> action = this.getLatestAction();
        if (action.isPresent()) {
            BuildAction buildAction = (BuildAction)action.get();
            response.sendRedirect2(String.format("../../../%s%s", buildAction.getOwner().getUrl(), buildAction.getUrlName()));
        }
    }

    public Optional<T> getLatestAction() {
        return BuildAction.getBuildActionFromHistoryStartingFrom(this.owner.getLastBuild(), this.buildActionClass);
    }
}

