/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.util.CharsetValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.TypeSelector;

public abstract class AgentFileVisitor<T extends Serializable>
extends MasterToSlaveFileCallable<FileVisitorResult<T>> {
    private static final long serialVersionUID = 2216842481400265078L;
    private final String filePattern;
    private final String encoding;
    private final boolean followSymbolicLinks;
    private final boolean errorOnEmptyFiles;
    private final FileSystemFacade fileSystemFacade;
    private static final String EMPTY_FILE = "Skipping file '%s' because it's empty";

    protected AgentFileVisitor(String filePattern, String encoding, boolean followSymbolicLinks, boolean errorOnEmptyFiles) {
        this(filePattern, encoding, followSymbolicLinks, errorOnEmptyFiles, new FileSystemFacade());
    }

    @VisibleForTesting
    AgentFileVisitor(String filePattern, String encoding, boolean followSymbolicLinks, boolean errorOnEmptyFiles, FileSystemFacade fileSystemFacade) {
        this.filePattern = filePattern;
        this.encoding = encoding;
        this.followSymbolicLinks = followSymbolicLinks;
        this.errorOnEmptyFiles = errorOnEmptyFiles;
        this.fileSystemFacade = fileSystemFacade;
    }

    public final FileVisitorResult<T> invoke(File workspace, VirtualChannel channel) {
        FilteredLog log = new FilteredLog("Errors during parsing");
        log.logInfo("Searching for all files in '%s' that match the pattern '%s'", this.fileSystemFacade.getAbsolutePath(workspace), this.filePattern);
        log.logInfo("Traversing of symbolic links: %s", this.followSymbolicLinks ? "enabled" : "disabled");
        String[] fileNames = this.fileSystemFacade.find(this.filePattern, this.followSymbolicLinks, workspace);
        if (fileNames.length == 0) {
            log.logError("No files found for pattern '%s'. Configuration error?", this.filePattern);
            return new FileVisitorResult(log);
        }
        log.logInfo("-> found %s", this.plural(fileNames.length, "file"));
        return new FileVisitorResult<T>(log, this.scanFiles(workspace, fileNames, log));
    }

    private List<T> scanFiles(File workspace, String[] fileNames, FilteredLog log) {
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        for (String fileName : fileNames) {
            Path file = this.fileSystemFacade.resolve(workspace, fileName);
            if (this.fileSystemFacade.isNotReadable(file)) {
                log.logError("Skipping file '%s' because Jenkins has no permission to read the file", fileName);
                continue;
            }
            if (this.fileSystemFacade.isEmpty(file)) {
                if (this.errorOnEmptyFiles) {
                    log.logError(EMPTY_FILE, fileName);
                    continue;
                }
                log.logInfo(EMPTY_FILE, fileName);
                continue;
            }
            Optional<T> result = this.processFile(file, new CharsetValidation().getCharset(this.encoding), log);
            if (result.isPresent()) {
                results.add((Serializable)result.get());
                log.logInfo("Successfully processed file '%s'", fileName);
                continue;
            }
            log.logError("No result created for file '%s' due to some errors", fileName);
        }
        return results;
    }

    protected String plural(int count, String itemName) {
        return String.format("%d %s%s", count, itemName, count == 1 ? "" : "s");
    }

    protected abstract Optional<T> processFile(Path var1, Charset var2, FilteredLog var3);

    static class FileSystemFacade
    implements Serializable {
        private static final long serialVersionUID = 4052720703351280685L;

        FileSystemFacade() {
        }

        String getAbsolutePath(File file) {
            return file.getAbsolutePath();
        }

        String[] find(String includesPattern, boolean followSymbolicLinks, File workspace) {
            return new FileFinder(includesPattern, "", followSymbolicLinks).find(workspace);
        }

        Path resolve(File folder, String fileName) {
            return folder.toPath().resolve(fileName);
        }

        boolean isNotReadable(Path file) {
            return !Files.isReadable(file);
        }

        boolean isEmpty(Path file) {
            try {
                return Files.size(file) <= 0L;
            }
            catch (IOException e) {
                return true;
            }
        }
    }

    public static class FileVisitorResult<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 2122230867938547733L;
        private final FilteredLog log;
        private final List<T> results;

        FileVisitorResult(FilteredLog log) {
            this(log, Collections.emptyList());
        }

        FileVisitorResult(FilteredLog log, List<T> results) {
            this.log = log;
            this.results = new ArrayList<T>(results);
        }

        public FilteredLog getLog() {
            return this.log;
        }

        public List<T> getResults() {
            return Collections.unmodifiableList(this.results);
        }

        public boolean hasErrors() {
            return !this.getLog().getErrorMessages().isEmpty();
        }
    }

    static class FileFinder
    extends MasterToSlaveFileCallable<String[]> {
        private static final long serialVersionUID = 2970029366847565970L;
        private final String includesPattern;
        private final String excludesPattern;
        private final boolean followSymbolicLinks;

        FileFinder(String includesPattern, String excludesPattern) {
            this(includesPattern, excludesPattern, false);
        }

        FileFinder(String includesPattern, String excludesPattern, boolean followSymbolicLinks) {
            this.includesPattern = includesPattern;
            this.excludesPattern = excludesPattern;
            this.followSymbolicLinks = followSymbolicLinks;
        }

        public String[] invoke(File workspace, VirtualChannel channel) {
            return this.find(workspace);
        }

        public String[] find(File workspace) {
            try {
                FileSet fileSet = new FileSet();
                Project antProject = new Project();
                fileSet.setProject(antProject);
                fileSet.setDir(workspace);
                fileSet.setIncludes(this.includesPattern);
                TypeSelector selector = new TypeSelector();
                TypeSelector.FileType fileType = new TypeSelector.FileType();
                fileType.setValue("file");
                selector.setType(fileType);
                fileSet.addType(selector);
                if (StringUtils.isNotBlank((CharSequence)this.excludesPattern)) {
                    fileSet.setExcludes(this.excludesPattern);
                }
                fileSet.setFollowSymlinks(this.followSymbolicLinks);
                return fileSet.getDirectoryScanner(antProject).getIncludedFiles();
            }
            catch (BuildException ignored) {
                return new String[0];
            }
        }
    }
}

