/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class TreeString
implements Serializable {
    private static final long serialVersionUID = 3621959682117480904L;
    @Nullable
    private TreeString parent;
    private char[] label;

    TreeString() {
        this(null, "");
    }

    TreeString(@Nullable TreeString parent, String label) {
        Ensure.that(parent == null || !label.isEmpty()).isTrue("if there's a parent '%s', label '%s' can't be empty", parent, label);
        this.parent = parent;
        this.label = label.toCharArray();
    }

    String getLabel() {
        return new String(this.label);
    }

    TreeString split(String prefix) {
        Ensure.that(this.getLabel().startsWith(prefix)).isTrue();
        char[] suffix = new char[this.label.length - prefix.length()];
        System.arraycopy(this.label, prefix.length(), suffix, 0, suffix.length);
        TreeString middle = new TreeString(this.parent, prefix);
        this.label = suffix;
        this.parent = middle;
        return middle;
    }

    @VisibleForTesting
    @Nullable
    TreeString getParent() {
        return this.parent;
    }

    private int depth() {
        int i = 0;
        TreeString p = this;
        while (p != null) {
            ++i;
            p = p.parent;
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeString that = (TreeString)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        char[][] tokens = new char[this.depth()][];
        int i = tokens.length;
        int sz = 0;
        TreeString p = this;
        while (p != null) {
            tokens[--i] = p.label;
            sz += p.label.length;
            p = p.parent;
        }
        StringBuilder buf = new StringBuilder(sz);
        for (char[] token : tokens) {
            buf.append(token);
        }
        return buf.toString();
    }

    void dedup(Map<String, char[]> table) {
        String l = this.getLabel();
        char[] v = table.get(l);
        if (v == null) {
            table.put(l, this.label);
        } else {
            this.label = v;
        }
    }

    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.toString());
    }

    public static TreeString valueOf(String string) {
        return new TreeString(null, string);
    }
}

