/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FilteredLog
implements Serializable {
    private static final long serialVersionUID = -8552323621953159904L;
    private static final String SKIPPED_MESSAGE = "  ... skipped logging of %d additional errors ...";
    private static final int DEFAULT_MAX_LINES = 20;
    private final String title;
    private final int maxLines;
    private int lines = 0;
    private final List<String> infoMessages = new ArrayList<String>();
    private final List<String> errorMessages = new ArrayList<String>();

    public FilteredLog(String title) {
        this(title, 20);
    }

    public FilteredLog(String title, int maxLines) {
        this.title = title;
        this.maxLines = maxLines;
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.errorMessages.add(String.format(format, args));
        }
        ++this.lines;
    }

    private void printTitle() {
        if (this.lines == 0) {
            this.errorMessages.add(this.title);
        }
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.errorMessages.add(String.format(format, args));
            this.errorMessages.addAll(Arrays.asList(ExceptionUtils.getRootCauseStackTrace((Throwable)exception)));
        }
        ++this.lines;
    }

    public int size() {
        return this.lines;
    }

    public void logSummary() {
        if (this.lines > this.maxLines) {
            this.errorMessages.add(String.format(SKIPPED_MESSAGE, this.lines - this.maxLines));
        }
    }

    public List<String> getInfoMessages() {
        return Collections.unmodifiableList(this.infoMessages);
    }

    public List<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }
}

