/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class Ensure {
    @CheckReturnValue
    public static BooleanCondition that(boolean value) {
        return new BooleanCondition(value);
    }

    @CheckReturnValue
    public static ObjectCondition that(@Nullable Object value, Object ... additionalValues) {
        return new ObjectCondition(value, additionalValues);
    }

    @CheckReturnValue
    public static IterableCondition that(@Nullable Iterable<?> value) {
        return new IterableCondition(value);
    }

    @CheckReturnValue
    public static CollectionCondition that(@Nullable Collection<?> value) {
        return new CollectionCondition(value);
    }

    @CheckReturnValue
    public static ArrayCondition that(@Nullable Object[] value) {
        return new ArrayCondition(value);
    }

    @CheckReturnValue
    public static StringCondition that(@Nullable String value) {
        return new StringCondition(value);
    }

    @CheckReturnValue
    public static ExceptionCondition that(@Nullable Throwable value) {
        return new ExceptionCondition(value);
    }

    public static void thatStatementIsNeverReached() {
        Ensure.throwException("This statement should never be reached.", new Object[0]);
    }

    @FormatMethod
    public static void thatStatementIsNeverReached(String explanation, Object ... args) {
        Ensure.throwException(explanation, args);
    }

    @FormatMethod
    private static void throwException(String message, Object ... args) {
        throw new AssertionError((Object)String.format(message, args));
    }

    @FormatMethod
    private static void throwNullPointerException(String message, Object ... args) {
        throw new NullPointerException(String.format(message, args));
    }

    private Ensure() {
    }

    public static class ExceptionCondition {
        @Nullable
        private final Throwable value;

        public ExceptionCondition(@Nullable Throwable value) {
            this.value = value;
        }

        @FormatMethod
        public void isNeverThrown(String explanation, Object ... args) {
            throw new AssertionError(String.format(explanation, args), this.value);
        }
    }

    public static class BooleanCondition {
        private final boolean value;

        public BooleanCondition(boolean value) {
            this.value = value;
        }

        @FormatMethod
        public void isFalse(String explanation, Object ... args) {
            if (this.value) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isFalse() {
            this.isFalse("Value is not FALSE", new Object[0]);
        }

        @FormatMethod
        public void isTrue(String explanation, Object ... args) {
            if (!this.value) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isTrue() {
            this.isTrue("Value is not TRUE", new Object[0]);
        }
    }

    public static class ObjectCondition {
        @Nullable
        private final Object value;
        @Nullable
        private final Object[] additionalValues;

        public ObjectCondition(@Nullable Object value) {
            this(value, new Object[0]);
        }

        @SuppressFBWarnings(value={"EI2"})
        public ObjectCondition(@Nullable Object value, Object ... additionalValues) {
            this.value = value;
            this.additionalValues = additionalValues;
        }

        public void isNotNull() {
            this.isNotNull("Object is NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotNull(String explanation, Object ... args) {
            if (this.value == null) {
                Ensure.throwNullPointerException(explanation, args);
            }
            for (Object additionalValue : this.additionalValues) {
                if (additionalValue != null) continue;
                Ensure.throwNullPointerException(explanation, args);
            }
        }

        public void isNull() {
            this.isNull("Object is not NULL", new Object[0]);
        }

        @FormatMethod
        public void isNull(String explanation, Object ... args) {
            if (this.value != null) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isInstanceOf(Class<?> type, Class<?> ... additionalTypes) {
            this.isNotNull();
            ArrayList types = new ArrayList();
            types.add(type);
            Collections.addAll(types, additionalTypes);
            for (Class clazz : types) {
                if (!clazz.isInstance(this.value)) continue;
                return;
            }
            Ensure.throwException("Object is of wrong type. Actual: %s. Expected one of: %s", new Object[]{this.value, types});
        }

        @FormatMethod
        public void isInstanceOf(Class<?> type, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (!type.isInstance(this.value)) {
                Ensure.throwException(explanation, args);
            }
        }
    }

    public static class StringCondition
    extends ObjectCondition {
        @Nullable
        private final String value;

        public StringCondition(@Nullable String value) {
            super(value);
            this.value = value;
        }

        public void isNotEmpty() {
            this.isNotEmpty("The string is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.isEmpty()) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isNotBlank() {
            this.isNotBlank("The string is blank", new Object[0]);
        }

        @FormatMethod
        public void isNotBlank(String explanation, Object ... args) {
            this.isNotNull();
            if (this.isBlank()) {
                Ensure.throwException(explanation, args);
            }
        }

        private boolean isBlank() {
            if (this.value.isEmpty()) {
                return true;
            }
            for (int i = 0; i < this.value.length(); ++i) {
                if (Character.isWhitespace(this.value.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ArrayCondition
    extends ObjectCondition {
        @Nullable
        private final Object[] values;

        @SuppressFBWarnings(value={"EI2"})
        public ArrayCondition(@Nullable Object[] values) {
            super(values);
            this.values = values;
        }

        public void isNotEmpty() {
            this.isNotEmpty("Array is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.values.length == 0) {
                Ensure.throwException(explanation, args);
            } else {
                for (Object object : this.values) {
                    if (object != null) continue;
                    Ensure.throwException(explanation, args);
                }
            }
        }
    }

    public static class CollectionCondition
    extends IterableCondition {
        @Nullable
        private final Collection<?> value;

        public CollectionCondition(@Nullable Collection<?> value) {
            super(value);
            this.value = value;
        }

        public void contains(Object element) {
            this.contains(element, "Collection %s does not contain element '%s'", this.value, element);
        }

        @FormatMethod
        public void contains(Object element, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (!this.value.contains(element)) {
                Ensure.throwException(explanation, args);
            }
        }

        public void doesNotContain(Object element) {
            this.doesNotContain(element, "Collection '%s' contains element '%s'", this.value, element);
        }

        @FormatMethod
        public void doesNotContain(Object element, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.contains(element)) {
                Ensure.throwException(explanation, args);
            }
        }
    }

    public static class IterableCondition
    extends ObjectCondition {
        @Nullable
        private final Iterable<?> value;

        public IterableCondition(@Nullable Iterable<?> value) {
            super(value);
            this.value = value;
        }

        public void isNotEmpty() {
            this.isNotEmpty("Iterable is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.iterator().hasNext()) {
                for (Object object : this.value) {
                    if (object != null) continue;
                    Ensure.throwException(explanation, args);
                }
            } else {
                Ensure.throwException(explanation, args);
            }
        }
    }
}

