/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.restful.api;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.DataBoundConstructor;

public class HttpFlowDefinition
extends FlowDefinition {
    private String url;
    private String scriptPath;
    private boolean sandbox;
    private String script;

    @DataBoundConstructor
    public HttpFlowDefinition(String url, String scriptPath) {
        this.url = url;
        this.scriptPath = scriptPath;
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        try (InputStream input = new URL(this.url).openStream();){
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)data);
            this.script = data.toString();
        }
        return new CpsFlowExecution(this.script, this.sandbox, owner);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public String getDisplayName() {
            return "Pipeline script from URL";
        }
    }
}

