/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.restful.api;

import com.cloudbees.workflow.util.ServeJson;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipeline.restful.api.JenkinsInstance;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.identity.IdentityRootAction;
import jenkins.security.ApiTokenProperty;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponseWrapper;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class InstanceAPI
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(InstanceAPI.class.getName());

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Jenkins instance API";
    }

    @CheckForNull
    public String getUrlName() {
        return "instance";
    }

    @ServeJson
    public JenkinsInstance doIndex() {
        IdentityRootAction identityAction = new IdentityRootAction();
        JenkinsInstance jenkinsInstance = new JenkinsInstance(identityAction.getFingerprint(), identityAction.getPublicKey());
        jenkinsInstance.setSystemMessage(Jenkins.get().getSystemMessage());
        return jenkinsInstance;
    }

    @ServeJson
    public Properties doSystemProperties() {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            LOGGER.severe("no permission to get system properties");
            return new Properties();
        }
        return System.getProperties();
    }

    @ServeJson
    public Map<String, String> doSystemEnv() {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            LOGGER.severe("no permission to get system environment");
            return new HashMap<String, String>();
        }
        return System.getenv();
    }

    @RequirePOST
    public HttpResponse doUpdateMessage(StaplerRequest req) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            LOGGER.severe("no permission to set system message");
            return HttpResponses.errorJSON((String)"no permission to set system message");
        }
        String message = req.getParameter("message");
        try {
            Jenkins.get().setSystemMessage(message);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "cannot set system message of Jenkins", e);
            return HttpResponses.errorJSON((String)e.getMessage());
        }
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doAgentSecret(@QueryParameter String name) {
        try {
            return HttpResponses.text((String)JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(name));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "cannot get the slave secret", e);
            return HttpResponses.errorJSON((String)e.getMessage());
        }
    }

    public void doGenerateToken(StaplerResponse rsp, @QueryParameter(required=true) String callback) throws IOException, ServletException {
        User user = User.current();
        if (user == null) {
            System.out.println("not login yet");
            return;
        }
        ApiTokenProperty token = (ApiTokenProperty)user.getProperty(ApiTokenProperty.class);
        ApiTokenProperty.DescriptorImpl desc = (ApiTokenProperty.DescriptorImpl)token.getDescriptor();
        HttpResponse response = desc.doGenerateNewToken(user, "jcli-auto-");
        final ByteArrayOutputStream output = new ByteArrayOutputStream();
        StaplerResponseWrapper out = new StaplerResponseWrapper(rsp){

            public ServletOutputStream getOutputStream() throws IOException {
                return new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        output.write(b);
                    }

                    public boolean isReady() {
                        return false;
                    }

                    public void setWriteListener(WriteListener writeListener) {
                    }
                };
            }
        };
        response.generateResponse(null, (StaplerResponse)out, null);
        HttpURLConnection urlCon = (HttpURLConnection)new URL(callback).openConnection();
        urlCon.setRequestMethod("POST");
        urlCon.setDoOutput(true);
        urlCon.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        JSONObject jsonObj = JSONObject.fromObject((Object)output.toString());
        jsonObj.getJSONObject("data").put("userName", (Object)user.getFullName());
        urlCon.setFixedLengthStreamingMode(jsonObj.toString().length());
        try (OutputStream os = urlCon.getOutputStream();){
            os.write(jsonObj.toString().getBytes());
        }
        String result = "All set, jcli is ready! For example: 'jcli plugin list'. You can close this page now.";
        rsp.setContentLength(result.length());
        rsp.getWriter().write(result);
    }

    @RequirePOST
    public HttpResponse doSetLocation(@QueryParameter String rootURL, @QueryParameter String email) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return HttpResponses.errorJSON((String)"cannot set Jenkins location due to lack of permission");
        }
        JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
        if (config == null) {
            return HttpResponses.errorJSON((String)"cannot set Jenkins location due to it is undefined");
        }
        if (StringUtils.isNotBlank((String)rootURL)) {
            config.setUrl(rootURL);
        }
        if (StringUtils.isNotBlank((String)email)) {
            config.setAdminAddress(email);
        }
        config.save();
        return HttpResponses.ok();
    }

    @ServeJson
    public Map<String, String> doGetLocation() {
        HashMap<String, String> data = new HashMap<String, String>();
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return data;
        }
        JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
        if (config != null) {
            data.put("rootURL", config.getUrl());
            data.put("email", config.getAdminAddress());
        }
        return data;
    }
}

