/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.security.SecurityListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class AuditingSecurityListener
extends SecurityListener
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(AuditingSecurityListener.class.getName());
    private LongCounter loginSuccessCounter;
    private LongCounter loginFailureCounter;
    private LongCounter loginCounter;
    private EventEmitter eventEmitter;

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.eventEmitter = eventEmitter;
        this.loginSuccessCounter = meter.counterBuilder("login_success").setDescription("Successful logins").setUnit("1").build();
        this.loginFailureCounter = meter.counterBuilder("login_failure").setDescription("Failing logins").setUnit("1").build();
        this.loginCounter = meter.counterBuilder("login").setDescription("Logins").setUnit("1").build();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins authentication events...");
    }

    protected void authenticated2(@NonNull UserDetails details) {
        super.authenticated2(details);
    }

    protected void failedToAuthenticate(@NonNull String username) {
        super.failedToAuthenticate(username);
    }

    protected void loggedIn(@NonNull String username) {
        Authentication authentication;
        Object details;
        this.loginCounter.add(1L);
        this.loginSuccessCounter.add(1L);
        String message = "Successful login of user '" + username + "'";
        AttributesBuilder attributesBuilder = Attributes.builder();
        Optional<User> user = Optional.ofNullable(User.current());
        attributesBuilder.put(JenkinsOtelSemanticAttributes.EVENT_CATEGORY, (Object)"authentication").put(JenkinsOtelSemanticAttributes.EVENT_OUTCOME, (Object)"success").put(SemanticAttributes.ENDUSER_ID, (Object)user.map(User::getId).orElse(username));
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && (details = (authentication = securityContext.getAuthentication()).getDetails()) instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)details;
            attributesBuilder.put(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)webAuthenticationDetails.getRemoteAddress());
            message = message + " from " + webAuthenticationDetails.getRemoteAddress();
        }
        attributesBuilder.put("message", message);
        this.eventEmitter.emit("user_login", attributesBuilder.build());
    }

    protected void userCreated(@NonNull String username) {
        super.userCreated(username);
    }

    protected void failedToLogIn(@NonNull String username) {
        this.loginCounter.add(1L);
        this.loginFailureCounter.add(1L);
        String message = "Failed login of user '" + username + "'";
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(JenkinsOtelSemanticAttributes.EVENT_CATEGORY, (Object)"authentication").put(JenkinsOtelSemanticAttributes.EVENT_OUTCOME, (Object)"failure").put(SemanticAttributes.ENDUSER_ID, (Object)username);
        attributesBuilder.put("message", message);
        this.eventEmitter.emit("user_login", attributesBuilder.build());
    }

    protected void loggedOut(@NonNull String username) {
        super.loggedOut(username);
    }

    @Override
    public void beforeSdkShutdown() {
    }
}

