/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.queue;

import hudson.Extension;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringQueueListener
extends QueueListener
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(MonitoringQueueListener.class.getName());
    private final AtomicInteger blockedItemGauge = new AtomicInteger();
    private LongCounter leftItemCounter;
    private LongCounter timeInQueueInMillisCounter;

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        meter.gaugeBuilder("jenkins.queue.waiting").ofLongs().setDescription("Number of tasks in the queue with the status 'waiting', 'buildable' or 'pending'").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record((long)Optional.ofNullable(Jenkins.getInstanceOrNull()).map(j -> j.getQueue()).map(q -> q.getUnblockedItems().size()).orElse(0).intValue()));
        meter.gaugeBuilder("jenkins.queue.blocked").ofLongs().setDescription("Number of blocked tasks in the queue. Note that waiting for an executor to be available is not a reason to be counted as blocked").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record(this.blockedItemGauge.longValue()));
        meter.gaugeBuilder("jenkins.queue.buildable").ofLongs().setDescription("Number of tasks in the queue with the status 'buildable' or 'pending'").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record((long)Optional.ofNullable(Jenkins.getInstanceOrNull()).map(j -> j.getQueue()).map(q -> q.countBuildableItems()).orElse(0).intValue()));
        this.leftItemCounter = meter.counterBuilder("jenkins.queue.left").setDescription("Total count of tasks that have been processed").setUnit("1").build();
        this.timeInQueueInMillisCounter = meter.counterBuilder("jenkins.queue.time_spent_millis").setDescription("Total time spent in queue by the tasks that have been processed").setUnit("ms").build();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins queue...");
    }

    public void onEnterBlocked(Queue.BlockedItem bi) {
        this.blockedItemGauge.incrementAndGet();
    }

    public void onLeaveBlocked(Queue.BlockedItem bi) {
        this.blockedItemGauge.decrementAndGet();
    }

    public void onLeft(Queue.LeftItem li) {
        this.leftItemCounter.add(1L);
        this.timeInQueueInMillisCounter.add(System.currentTimeMillis() - li.getInQueueSince());
        LOGGER.log(Level.FINE, () -> "onLeft(): " + li);
    }
}

