/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.opentelemetry.resources;

import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JenkinsResourceProvider
implements ResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(JenkinsResourceProvider.class.getName());

    public Resource createResource(ConfigProperties config) {
        ResourceBuilder resourceBuilder = Resource.builder();
        resourceBuilder.put(ResourceAttributes.SERVICE_NAME, (Object)"jenkins");
        resourceBuilder.put(ResourceAttributes.SERVICE_NAMESPACE, (Object)"jenkins");
        String jenkinsVersion = config.getString(JenkinsOtelSemanticAttributes.JENKINS_VERSION.getKey());
        resourceBuilder.put(ResourceAttributes.SERVICE_VERSION, (Object)jenkinsVersion);
        resourceBuilder.put(JenkinsOtelSemanticAttributes.JENKINS_VERSION.getKey(), jenkinsVersion);
        String jenkinsUrl = config.getString(JenkinsOtelSemanticAttributes.JENKINS_URL.getKey());
        resourceBuilder.put(JenkinsOtelSemanticAttributes.JENKINS_URL, (Object)jenkinsUrl);
        resourceBuilder.put(ResourceAttributes.SERVICE_INSTANCE_ID, (Object)config.getString(ResourceAttributes.SERVICE_INSTANCE_ID.getKey()));
        Resource resource = resourceBuilder.build();
        LOGGER.log(Level.FINER, () -> "Jenkins resource: " + resource);
        return resource;
    }
}

