/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.opentelemetry;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClosingOpenTelemetry
implements OpenTelemetry,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(ClosingOpenTelemetry.class.getName());
    final OpenTelemetry delegate;
    final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    public static ClosingOpenTelemetry noop() {
        return new ClosingOpenTelemetry(OpenTelemetry.noop());
    }

    @Override
    public void close() {
        ArrayList<AutoCloseable> instruments = new ArrayList<AutoCloseable>(this.closeables);
        this.closeables.clear();
        LOGGER.log(Level.FINE, () -> "Close " + instruments.size() + " instruments");
        LOGGER.log(Level.FINEST, () -> "Close " + instruments);
        for (AutoCloseable instrument : instruments) {
            try {
                instrument.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception closing " + instrument, e);
            }
        }
    }

    public ClosingOpenTelemetry(OpenTelemetry delegate) {
        this.delegate = delegate;
    }

    public TracerProvider getTracerProvider() {
        return this.delegate.getTracerProvider();
    }

    public Tracer getTracer(String instrumentationScopeName) {
        return this.delegate.getTracer(instrumentationScopeName);
    }

    public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.delegate.getTracer(instrumentationScopeName, instrumentationScopeVersion);
    }

    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.delegate.tracerBuilder(instrumentationScopeName);
    }

    public MeterProvider getMeterProvider() {
        return new ClosingMeterProvider(this.delegate.getMeterProvider());
    }

    public Meter getMeter(String instrumentationScopeName) {
        return new ClosingMeter(this.delegate.getMeter(instrumentationScopeName));
    }

    public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return new ClosingMeterBuilder(this.delegate.meterBuilder(instrumentationScopeName));
    }

    public ContextPropagators getPropagators() {
        return this.delegate.getPropagators();
    }

    class ClosingMeterProvider
    implements MeterProvider {
        final MeterProvider delegate;

        public ClosingMeterProvider(MeterProvider delegate) {
            this.delegate = delegate;
        }

        public Meter get(String instrumentationScopeName) {
            return new ClosingMeter(this.delegate.get(instrumentationScopeName));
        }

        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return new ClosingMeterBuilder(this.delegate.meterBuilder(instrumentationScopeName));
        }
    }

    class ClosingMeter
    implements Meter {
        private final Meter delegate;

        ClosingMeter(Meter delegate) {
            this.delegate = delegate;
        }

        public LongCounterBuilder counterBuilder(String name) {
            return new ClosingLongCounterBuilder(this.delegate.counterBuilder(name));
        }

        public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
            return new ClosingLongUpDownCounterBuilder(this.delegate.upDownCounterBuilder(name));
        }

        public DoubleHistogramBuilder histogramBuilder(String name) {
            return this.delegate.histogramBuilder(name);
        }

        public DoubleGaugeBuilder gaugeBuilder(String name) {
            return new ClosingDoubleGaugeBuilder(this.delegate.gaugeBuilder(name));
        }

        public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
            BatchCallback batchCallback = this.delegate.batchCallback(callback, observableMeasurement, additionalMeasurements);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)batchCallback);
            return batchCallback;
        }
    }

    class ClosingMeterBuilder
    implements MeterBuilder {
        final MeterBuilder delegate;

        ClosingMeterBuilder(MeterBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public MeterBuilder setSchemaUrl(String schemaUrl) {
            this.delegate.setSchemaUrl(schemaUrl);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public MeterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        public Meter build() {
            return new ClosingMeter(this.delegate.build());
        }
    }

    class ClosingDoubleCounterBuilder
    implements DoubleCounterBuilder {
        final DoubleCounterBuilder delegate;

        ClosingDoubleCounterBuilder(DoubleCounterBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleCounterBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleCounterBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public DoubleCounter build() {
            return this.delegate.build();
        }

        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            ObservableDoubleCounter observableDoubleCounter = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableDoubleCounter);
            return observableDoubleCounter;
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }
    }

    class ClosingLongGaugeBuilder
    implements LongGaugeBuilder {
        final LongGaugeBuilder delegate;

        ClosingLongGaugeBuilder(LongGaugeBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongGaugeBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongGaugeBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            ObservableLongGauge observableLongGauge = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableLongGauge);
            return observableLongGauge;
        }

        public ObservableLongMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }
    }

    class ClosingDoubleGaugeBuilder
    implements DoubleGaugeBuilder {
        final DoubleGaugeBuilder delegate;

        ClosingDoubleGaugeBuilder(DoubleGaugeBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleGaugeBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleGaugeBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public LongGaugeBuilder ofLongs() {
            return new ClosingLongGaugeBuilder(this.delegate.ofLongs());
        }

        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            ObservableDoubleGauge observableDoubleGauge = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableDoubleGauge);
            return observableDoubleGauge;
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }
    }

    class ClosingDoubleUpDownCounterBuilder
    implements DoubleUpDownCounterBuilder {
        final DoubleUpDownCounterBuilder delegate;

        ClosingDoubleUpDownCounterBuilder(DoubleUpDownCounterBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public DoubleUpDownCounter build() {
            return this.delegate.build();
        }

        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            ObservableDoubleUpDownCounter observableDoubleUpDownCounter = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableDoubleUpDownCounter);
            return observableDoubleUpDownCounter;
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }
    }

    class ClosingLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        final LongUpDownCounterBuilder delegate;

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongUpDownCounterBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongUpDownCounterBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public DoubleUpDownCounterBuilder ofDoubles() {
            return new ClosingDoubleUpDownCounterBuilder(this.delegate.ofDoubles());
        }

        public LongUpDownCounter build() {
            return this.delegate.build();
        }

        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            ObservableLongUpDownCounter observableLongUpDownCounter = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableLongUpDownCounter);
            return observableLongUpDownCounter;
        }

        public ObservableLongMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }

        ClosingLongUpDownCounterBuilder(LongUpDownCounterBuilder delegate) {
            this.delegate = delegate;
        }
    }

    class ClosingLongCounterBuilder
    implements LongCounterBuilder {
        final LongCounterBuilder delegate;

        ClosingLongCounterBuilder(LongCounterBuilder delegate) {
            this.delegate = delegate;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongCounterBuilder setDescription(String description) {
            this.delegate.setDescription(description);
            return this;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public LongCounterBuilder setUnit(String unit) {
            this.delegate.setUnit(unit);
            return this;
        }

        public DoubleCounterBuilder ofDoubles() {
            return new ClosingDoubleCounterBuilder(this.delegate.ofDoubles());
        }

        public LongCounter build() {
            return this.delegate.build();
        }

        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            ObservableLongCounter observableLongCounter = this.delegate.buildWithCallback(callback);
            ClosingOpenTelemetry.this.closeables.add((AutoCloseable)observableLongCounter);
            return observableLongCounter;
        }

        public ObservableLongMeasurement buildObserver() {
            return this.delegate.buildObserver();
        }
    }
}

