/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.trace.Span;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class WithSpanAttributeStep
extends Step {
    private static final Logger logger = Logger.getLogger(WithSpanAttributeStep.class.getName());
    String key;
    Object value;
    AttributeType type;
    Target target;

    @DataBoundConstructor
    public WithSpanAttributeStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.value == null) {
            return new StepExecution(context){

                public boolean start() {
                    return false;
                }
            };
        }
        AttributeType type = this.type;
        if (type == null) {
            boolean isArray = this.value.getClass().isArray();
            type = this.value instanceof Boolean ? (isArray ? AttributeType.BOOLEAN_ARRAY : AttributeType.BOOLEAN) : (this.value instanceof Double || this.value instanceof Float ? (isArray ? AttributeType.DOUBLE_ARRAY : AttributeType.DOUBLE) : (this.value instanceof Long || this.value instanceof Integer ? (isArray ? AttributeType.LONG_ARRAY : AttributeType.LONG) : (isArray ? AttributeType.STRING_ARRAY : AttributeType.STRING)));
        }
        return new Execution(this.key, this.value, type, Objects.requireNonNullElse(this.target, Target.CURRENT_SPAN), context);
    }

    public String getKey() {
        return this.key;
    }

    @DataBoundSetter
    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    @DataBoundSetter
    public void setValue(Object value) {
        this.value = value;
    }

    @CheckForNull
    public String getType() {
        return Optional.ofNullable(this.type).map(Enum::name).orElse(null);
    }

    @DataBoundSetter
    public void setType(String type) {
        this.type = Optional.ofNullable(type).map(String::trim).filter(Predicate.not(String::isEmpty)).map(String::toUpperCase).map(AttributeType::valueOf).orElse(null);
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = Optional.ofNullable(target).map(String::trim).filter(Predicate.not(String::isEmpty)).map(String::toUpperCase).map(Target::valueOf).orElse(null);
    }

    @CheckForNull
    public String getTarget() {
        return Optional.ofNullable(this.target).map(Enum::name).orElse(null);
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        private final String key;
        private final Object value;
        private final AttributeType attributeType;
        private final Target target;
        private static final long serialVersionUID = 1L;

        Execution(String key, Object value, AttributeType attributeType, Target target, StepContext context) {
            super(context);
            this.key = key;
            this.value = value;
            this.attributeType = attributeType;
            this.target = target;
        }

        protected Void run() throws Exception {
            Object convertedValue;
            AttributeKey attributeKey;
            Span span;
            OtelTraceService otelTraceService = (OtelTraceService)ExtensionList.lookupSingleton(OtelTraceService.class);
            Run run = (Run)this.getContext().get(Run.class);
            FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
            switch (this.target) {
                case PIPELINE_ROOT_SPAN: {
                    span = otelTraceService.getPipelineRootSpan(run);
                    break;
                }
                case CURRENT_SPAN: {
                    span = otelTraceService.getSpan(run, flowNode);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported target span '" + this.target + "'. ");
                }
            }
            switch (this.attributeType) {
                case BOOLEAN: {
                    attributeKey = AttributeKey.booleanKey((String)this.key);
                    convertedValue = this.value instanceof Boolean ? this.value : Boolean.valueOf(Boolean.parseBoolean(this.value.toString()));
                    break;
                }
                case DOUBLE: {
                    attributeKey = AttributeKey.doubleKey((String)this.key);
                    convertedValue = this.value instanceof Double ? this.value : Double.valueOf(this.value instanceof Float ? ((Float)this.value).doubleValue() : Double.parseDouble(this.value.toString()));
                    break;
                }
                case STRING: {
                    attributeKey = AttributeKey.stringKey((String)this.key);
                    convertedValue = this.value instanceof String ? this.value : this.value.toString();
                    break;
                }
                case LONG: {
                    attributeKey = AttributeKey.longKey((String)this.key);
                    convertedValue = this.value instanceof Long ? this.value : Long.valueOf(this.value instanceof Integer ? ((Integer)this.value).longValue() : Long.parseLong(this.value.toString()));
                    break;
                }
                case BOOLEAN_ARRAY: {
                    attributeKey = AttributeKey.booleanArrayKey((String)this.key);
                    convertedValue = this.value;
                    break;
                }
                case DOUBLE_ARRAY: {
                    attributeKey = AttributeKey.doubleArrayKey((String)this.key);
                    convertedValue = this.value;
                    break;
                }
                case LONG_ARRAY: {
                    attributeKey = AttributeKey.longArrayKey((String)this.key);
                    convertedValue = this.value;
                    break;
                }
                case STRING_ARRAY: {
                    attributeKey = AttributeKey.stringArrayKey((String)this.key);
                    convertedValue = this.value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported span attribute type '" + this.attributeType + "'. ");
                }
            }
            logger.log(Level.FINE, () -> "setSpanAttribute: run=\"" + run.getParent().getName() + "#" + run.getId() + "\", key=" + this.key + " value=\"" + this.value + "\" type=" + this.attributeType);
            span.setAttribute(attributeKey, convertedValue);
            return null;
        }
    }

    static enum Target {
        CURRENT_SPAN,
        PIPELINE_ROOT_SPAN;

    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public static final String FUNCTION_NAME = "withSpanAttribute";

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return FUNCTION_NAME;
        }

        @NonNull
        public String getDisplayName() {
            return "Set Span Attribute";
        }

        public ListBoxModel doFillTypeItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            List<AttributeType> supportedAttributeTypes = Arrays.asList(AttributeType.STRING, AttributeType.LONG, AttributeType.BOOLEAN, AttributeType.DOUBLE);
            return new ListBoxModel((Collection)supportedAttributeTypes.stream().map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }

        public ListBoxModel doFillTargetItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            return new ListBoxModel((Collection)Arrays.stream(Target.values()).map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }
    }
}

