/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStep;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class BuildTriggerStepHandler
implements StepHandler {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerStepHandler.class.getName());

    @Override
    public boolean canCreateSpanBuilder(@NonNull FlowNode flowNode, @NonNull WorkflowRun run) {
        return flowNode instanceof StepAtomNode && ((StepAtomNode)flowNode).getDescriptor() instanceof BuildTriggerStep.DescriptorImpl;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull FlowNode node, @NonNull WorkflowRun run, @NonNull Tracer tracer) {
        Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
        String job = Preconditions.checkNotNull(arguments.get("job")).toString();
        SpanBuilder spanBuilder = tracer.spanBuilder("build: " + job);
        spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_NAME, (Object)job);
        return spanBuilder;
    }

    @Override
    public void afterSpanCreated(StepAtomNode node, WorkflowRun run) {
        HashMap<String, String> context = new HashMap<String, String>();
        MonitoringAction monitoringAction = (MonitoringAction)run.getAction(MonitoringAction.class);
        W3CTraceContextPropagator.getInstance().inject(Context.current(), context, (carrier, key, value) -> carrier.put(key, value));
        monitoringAction.addContext((FlowNode)node, context);
    }
}

