/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public abstract class AbstractGitStepHandler
implements StepHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractGitStepHandler.class.getName());

    public String searchGitUserName(@Nullable String credentialsId, @NonNull WorkflowRun run) {
        if (credentialsId == null) {
            return null;
        }
        String gitUserName = credentialsId;
        StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernameCredentials.class, (Run)run, (DomainRequirement[])new DomainRequirement[0]);
        if (credentials != null && credentials.getUsername() != null) {
            gitUserName = credentials.getUsername();
        }
        return gitUserName;
    }

    @VisibleForTesting
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull String gitUrl, @Nullable String gitBranch, @Nullable String credentialsId, @NonNull String stepFunctionName, @NonNull Tracer tracer, @NonNull WorkflowRun run) {
        String gitUserName = this.searchGitUserName(credentialsId, run);
        return this.createSpanBuilderFromGitDetails(gitUrl, gitBranch, gitUserName, stepFunctionName, tracer);
    }

    @VisibleForTesting
    protected SpanBuilder createSpanBuilderFromGitDetails(@Nullable String gitUrl, @Nullable String gitBranch, @Nullable String gitUserName, @NonNull String stepFunctionName, @NonNull Tracer tracer) {
        SpanBuilder spanBuilder;
        URIish gitUri;
        try {
            gitUri = new URIish(gitUrl);
        }
        catch (URISyntaxException e) {
            return tracer.spanBuilder(stepFunctionName);
        }
        String host = gitUri.getHost();
        String gitRepositoryPath = this.normalizeGitRepositoryPath(gitUri);
        if ("https".equals(gitUri.getScheme())) {
            String spanName = stepFunctionName + ": " + host + "/" + gitRepositoryPath;
            spanBuilder = tracer.spanBuilder(spanName);
            spanBuilder.setAttribute(SemanticAttributes.RPC_SYSTEM, (Object)gitUri.getScheme()).setAttribute(SemanticAttributes.RPC_SERVICE, (Object)"git").setAttribute(SemanticAttributes.RPC_METHOD, (Object)"checkout").setAttribute(SemanticAttributes.NET_PEER_NAME, (Object)host).setAttribute(SemanticAttributes.PEER_SERVICE, (Object)host).setAttribute(SemanticAttributes.HTTP_URL, (Object)this.sanitizeUrl(gitUri)).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)"POST").setSpanKind(SpanKind.CLIENT);
        } else if ("ssh".equals(gitUri.getScheme()) || gitUri.getScheme() == null && gitUri.getHost() != null) {
            String spanName = stepFunctionName + ": " + host + "/" + gitRepositoryPath;
            spanBuilder = tracer.spanBuilder(spanName);
            spanBuilder.setAttribute(SemanticAttributes.RPC_SYSTEM, (Object)"ssh").setAttribute(SemanticAttributes.RPC_SERVICE, (Object)"git").setAttribute(SemanticAttributes.RPC_METHOD, (Object)"checkout").setAttribute(SemanticAttributes.NET_PEER_NAME, (Object)host).setAttribute(SemanticAttributes.PEER_SERVICE, (Object)host).setAttribute(SemanticAttributes.NET_TRANSPORT, (Object)"ip_tcp").setSpanKind(SpanKind.CLIENT);
        } else if ("file".equals(gitUri.getScheme()) || gitUri.getScheme() == null && gitUri.getHost() == null) {
            String spanName = stepFunctionName + ": " + gitRepositoryPath;
            spanBuilder = tracer.spanBuilder(spanName);
        } else {
            String spanName = stepFunctionName + ": " + host + "/" + gitRepositoryPath;
            spanBuilder = tracer.spanBuilder(spanName);
        }
        spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.GIT_REPOSITORY, (Object)gitRepositoryPath);
        if (!Strings.isNullOrEmpty((String)gitBranch)) {
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.GIT_BRANCH, (Object)gitBranch);
        }
        if (!Strings.isNullOrEmpty((String)gitUserName)) {
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.GIT_USERNAME, (Object)gitUserName);
        }
        return spanBuilder;
    }

    private String normalizeGitRepositoryPath(URIish gitUri) {
        String githubOrgAndRepository = gitUri.getPath();
        if (githubOrgAndRepository.startsWith("/")) {
            githubOrgAndRepository = githubOrgAndRepository.substring("/".length());
        }
        if (githubOrgAndRepository.endsWith(".git")) {
            githubOrgAndRepository = githubOrgAndRepository.substring(0, githubOrgAndRepository.length() - ".git".length());
        }
        return githubOrgAndRepository;
    }

    @NonNull
    protected String sanitizeUrl(@NonNull URIish gitUri) {
        String normalizedUrl = gitUri.getScheme() + "://";
        if (gitUri.getHost() != null) {
            normalizedUrl = normalizedUrl + gitUri.getHost();
        }
        if (gitUri.getPort() != -1) {
            normalizedUrl = normalizedUrl + ":" + gitUri.getPort();
        }
        normalizedUrl = normalizedUrl + gitUri.getPath();
        return normalizedUrl;
    }
}

