/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.runhandler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.job.runhandler.RunHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.ArrayList;
import jenkins.YesNoMaybe;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class MatrixRunHandler
implements RunHandler {
    private boolean expandJobName;

    public MatrixRunHandler() throws ClassNotFoundException {
        Class.forName(MatrixRun.class.getName());
    }

    @Override
    public boolean canCreateSpanBuilder(@NonNull Run run) {
        return run instanceof MatrixRun || run instanceof MatrixBuild;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull Run run, @NonNull Tracer tracer) {
        if (run instanceof MatrixRun) {
            MatrixRun matrixRun = (MatrixRun)run;
            MatrixConfiguration matrixConfiguration = matrixRun.getParent();
            MatrixProject matrixProject = matrixConfiguration.getParent();
            Object spanName = this.expandJobName ? run.getParent().getFullName() : matrixProject.getFullName() + "/execution";
            SpanBuilder spanBuilder = tracer.spanBuilder("BUILD " + (String)spanName);
            Combination combination = matrixConfiguration.getCombination();
            ArrayList axisNames = new ArrayList();
            ArrayList axisValues = new ArrayList();
            combination.entrySet().stream().forEach(entry -> {
                axisNames.add((String)entry.getKey());
                axisValues.add((String)entry.getValue());
            });
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_AXIS_NAMES, axisNames);
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_AXIS_VALUES, axisValues);
            return spanBuilder;
        }
        if (run instanceof MatrixBuild) {
            MatrixBuild matrixBuild = (MatrixBuild)run;
            return tracer.spanBuilder("BUILD " + ((MatrixProject)matrixBuild.getParent()).getFullName());
        }
        throw new IllegalStateException("Unsupported run type " + run);
    }

    @Override
    public void configure(ConfigProperties config) {
        this.expandJobName = Boolean.TRUE.equals(config.getBoolean("otel.instrumentation.jenkins.job.matrix.expand.job.name"));
    }
}

