/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.runhandler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.job.runhandler.RunHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Collection;
import javaposse.jobdsl.plugin.actions.SeedJobAction;
import javaposse.jobdsl.plugin.actions.SeedJobTransientActionFactory;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class JobDslRunHandler
implements RunHandler {
    private SeedJobTransientActionFactory seedJobTransientActionFactory;
    private boolean collapseJobName;

    public JobDslRunHandler() throws ClassNotFoundException {
        Class.forName(SeedJobAction.class.getName());
    }

    @Override
    public boolean canCreateSpanBuilder(@NonNull Run run) {
        Job job = run.getParent();
        Collection actions = this.seedJobTransientActionFactory.createFor((Item)job);
        return !actions.isEmpty();
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull Run run, @NonNull Tracer tracer) {
        Object spanName;
        String templateUrl;
        String templateFullName;
        Job job = run.getParent();
        Collection actions = this.seedJobTransientActionFactory.createFor((Item)job);
        SeedJobAction seedJobAction = (SeedJobAction)actions.stream().filter(action -> action instanceof SeedJobAction).findFirst().orElseThrow(() -> new IllegalStateException());
        Item seedJob = seedJobAction.getSeedJob();
        if (seedJob == null) {
            templateFullName = null;
            templateUrl = null;
            spanName = job.getFullName();
        } else {
            templateFullName = seedJob.getFullName();
            templateUrl = seedJob.getUrl();
            spanName = this.collapseJobName ? "Job from seed '" + templateFullName + "'" : job.getFullName();
        }
        SpanBuilder spanBuilder = tracer.spanBuilder("BUILD " + (String)spanName);
        if (templateFullName != null) {
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_TEMPLATE_ID, (Object)templateFullName);
        }
        if (templateUrl != null) {
            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_TEMPLATE_URL, (Object)templateUrl);
        }
        return spanBuilder;
    }

    @Override
    public void configure(ConfigProperties config) {
        this.collapseJobName = Boolean.TRUE.equals(config.getBoolean("otel.instrumentation.jenkins.job.dsl.collapse.job.name"));
    }

    @Override
    public int ordinal() {
        return 0x7FFFFFFE;
    }

    @Inject
    public void setSeedJobTransientActionFactory(@NonNull SeedJobTransientActionFactory seedJobTransientActionFactory) {
        this.seedJobTransientActionFactory = seedJobTransientActionFactory;
    }
}

