/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.framework.io.ByteBuffer;

public class InputStreamByteBuffer
extends ByteBuffer {
    static final Logger logger = Logger.getLogger(InputStreamByteBuffer.class.getName());
    @NonNull
    private final Tracer tracer;
    @NonNull
    final InputStream in;

    public InputStreamByteBuffer(InputStream in, Tracer tracer) {
        this.in = in;
        this.tracer = tracer;
    }

    public synchronized long length() {
        Tracer tracer = logger.isLoggable(Level.FINER) ? this.tracer : TracerProvider.noop().get("noop");
        long length = Long.parseLong(System.getProperty("hudson.consoleTailKB", "150")) * 1024L;
        Span span = tracer.spanBuilder("InputStreamByteBuffer.length").setAttribute("response.length", length).startSpan();
        try {
            long l;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    l = length;
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public InputStream newInputStream() {
        Tracer tracer = logger.isLoggable(Level.FINEST) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("InputStreamByteBuffer.newInputStream").startSpan();
        try {
            InputStream inputStream;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    inputStream = this.in;
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return inputStream;
        }
        finally {
            span.end();
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    public void write(@NonNull byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }
}

