/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import hudson.Main;
import hudson.console.AnnotatedLargeText;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.ByteBuffer;

public class OverallLog
extends AnnotatedLargeText<FlowExecutionOwner.Executable> {
    private static final Logger logger = Logger.getLogger(OverallLog.class.getName());
    private final FlowExecutionOwner.Executable context;
    private final transient Tracer tracer;
    private final LogsViewHeader logsViewHeader;

    public OverallLog(ByteBuffer memory, LogsViewHeader logsViewHeader, Charset charset, boolean completed, FlowExecutionOwner.Executable context, Tracer tracer) {
        super(memory, charset, completed, (Object)context);
        this.logsViewHeader = logsViewHeader;
        this.context = context;
        this.tracer = tracer;
    }

    public void doProgressiveHtml(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.doProgressiveHtml").startSpan();
        try (Scope scope = span.makeCurrent();){
            String xMoreData;
            String start = req.getParameter("start");
            if (start != null && !start.isEmpty()) {
                span.setAttribute("start", start);
            }
            super.doProgressiveHtml(req, rsp);
            String xTextSize = rsp.getHeader("X-Text-Size");
            if (xTextSize != null) {
                span.setAttribute("response.textSize", Long.parseLong(xTextSize));
            }
            if ((xMoreData = rsp.getHeader("X-More-Data")) != null) {
                span.setAttribute("response.moreData", Boolean.parseBoolean(xMoreData));
            }
        }
        catch (IOException e) {
            span.recordException((Throwable)e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public void doProgressiveText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.doProgressiveText").startSpan();
        try (Scope scope = span.makeCurrent();){
            String start = req.getParameter("start");
            if (start != null && !start.isEmpty()) {
                span.setAttribute("start", start);
            }
            super.doProgressiveText(req, rsp);
        }
        catch (IOException e) {
            span.recordException((Throwable)e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public long writeLogTo(long start, Writer w) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.writeLogTo(writer)").setAttribute("start", start).startSpan();
        try {
            long l;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    long length = super.writeLogTo(start, w);
                    span.setAttribute("response.lengthInBytes", length);
                    l = length;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public long writeLogTo(long start, OutputStream out) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.writeLogTo(outputStream)").setAttribute("start", start).startSpan();
        try {
            long l;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    long length = super.writeLogTo(start, out);
                    span.setAttribute("response.lengthInBytes", length);
                    l = length;
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public long writeRawLogTo(long start, OutputStream out) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.writeRawLogTo").setAttribute("start", start).startSpan();
        try {
            long l;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    long length = super.writeRawLogTo(start, out);
                    span.setAttribute("response.length", length);
                    l = length;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public long writeHtmlTo(long start, Writer w) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.writeHtmlTo").setAttribute("start", start).startSpan();
        try {
            long l;
            block12: {
                Scope scope = span.makeCurrent();
                try {
                    if (start == 0L && !Main.isUnitTest) {
                        this.logsViewHeader.writeHeader(w, this.context, this.charset);
                        w.write("\n\n");
                    }
                    long logLinesLengthInBytes = super.writeHtmlTo(start, w);
                    span.setAttribute("response.lengthBytes", logLinesLengthInBytes);
                    l = logLinesLengthInBytes;
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public Reader readAll() throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.readAll").startSpan();
        try {
            Reader reader;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    reader = super.readAll();
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                scope.close();
            }
            return reader;
        }
        finally {
            span.end();
        }
    }

    public void doProgressText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.doProgressText").startSpan();
        try (Scope scope = span.makeCurrent();){
            String xMoreData;
            String start = req.getParameter("start");
            if (start != null && !start.isEmpty()) {
                span.setAttribute("request.start", start);
            }
            super.doProgressText(req, rsp);
            String xTextSize = rsp.getHeader("X-Text-Size");
            if (xTextSize != null) {
                span.setAttribute("response.textSize", Long.parseLong(xTextSize));
            }
            if ((xMoreData = rsp.getHeader("X-More-Data")) != null) {
                span.setAttribute("response.moreData", Boolean.parseBoolean(xMoreData));
            }
        }
        catch (IOException e) {
            span.recordException((Throwable)e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    protected Writer createWriter(StaplerRequest req, StaplerResponse rsp, long size) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.createWriter").startSpan();
        try {
            Writer writer;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    writer = super.createWriter(req, rsp, size);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return writer;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsComplete() {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("OverallLog.markAsComplete").startSpan();
        try (Scope scope = span.makeCurrent();){
            super.markAsComplete();
        }
        finally {
            span.end();
        }
    }
}

