/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetryConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetrySdkProvider;
import io.jenkins.plugins.opentelemetry.job.log.BuildInfo;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.MergedBuildListener;
import io.jenkins.plugins.opentelemetry.job.log.MergedTaskListener;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogSenderBuildListener;
import io.jenkins.plugins.opentelemetry.job.log.OverallLog;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.FileLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;

class OtelLogStorage
implements LogStorage {
    private static final Logger logger = Logger.getLogger(OtelLogStorage.class.getName());
    final BuildInfo buildInfo;
    final String buildFolderPath;
    final Tracer tracer;

    public OtelLogStorage(@NonNull BuildInfo buildInfo, @NonNull Tracer tracer, @Nullable String buildFolderPath) {
        this.buildInfo = buildInfo;
        this.tracer = tracer;
        this.buildFolderPath = buildFolderPath;
    }

    @NonNull
    public BuildListener overallListener() throws IOException {
        OpenTelemetryConfiguration otelConfiguration = JenkinsOpenTelemetryPluginConfiguration.get().toOpenTelemetryConfiguration();
        Map<String, String> otelConfigurationProperties = otelConfiguration.toOpenTelemetryProperties();
        HashMap<String, String> otelResourceAttributes = new HashMap<String, String>();
        otelConfiguration.toOpenTelemetryResource().getAttributes().asMap().forEach((k, v) -> otelResourceAttributes.put(k.getKey(), v.toString()));
        OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController otelLogSenderBuildListenerOnController = new OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController(this.buildInfo, otelConfigurationProperties, otelResourceAttributes);
        if (OpenTelemetrySdkProvider.get().isOtelLogsMirrorToDisk()) {
            try {
                File logFile = new File(this.buildFolderPath, "log");
                return new MergedBuildListener((TaskListener)otelLogSenderBuildListenerOnController, (TaskListener)FileLogStorage.forFile((File)logFile).overallListener());
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("Was not possible to create the mirror logs.", e);
            }
        }
        return otelLogSenderBuildListenerOnController;
    }

    @NonNull
    public TaskListener nodeListener(@NonNull FlowNode flowNode) throws IOException {
        OpenTelemetryConfiguration otelConfiguration = JenkinsOpenTelemetryPluginConfiguration.get().toOpenTelemetryConfiguration();
        Map<String, String> otelConfigurationProperties = otelConfiguration.toOpenTelemetryProperties();
        HashMap<String, String> otelResourceAttributes = new HashMap<String, String>();
        otelConfiguration.toOpenTelemetryResource().getAttributes().asMap().forEach((k, v) -> otelResourceAttributes.put(k.getKey(), v.toString()));
        OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController otelLogSenderBuildListenerOnController = new OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController(this.buildInfo, flowNode.getId(), otelConfigurationProperties, otelResourceAttributes);
        if (OpenTelemetrySdkProvider.get().isOtelLogsMirrorToDisk()) {
            try {
                File logFile = new File(this.buildFolderPath, "log");
                return new MergedTaskListener((TaskListener)otelLogSenderBuildListenerOnController, FileLogStorage.forFile((File)logFile).nodeListener(flowNode));
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("Was not possible to create the mirror logs.", e);
            }
        }
        return otelLogSenderBuildListenerOnController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        File logFile = new File(this.buildFolderPath, "log");
        if (logFile.exists()) {
            return FileLogStorage.forFile((File)logFile).overallLog(build, complete);
        }
        Span span = this.tracer.spanBuilder("OtelLogStorage.overallLog").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.buildInfo.getJobFullName()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.buildInfo.runNumber).setAttribute("complete", complete).startSpan();
        try {
            OverallLog overallLog;
            block12: {
                Scope scope = span.makeCurrent();
                try {
                    LogStorageRetriever logStorageRetriever = this.getLogStorageRetriever();
                    LogsQueryResult logsQueryResult = logStorageRetriever.overallLog(this.buildInfo.getJobFullName(), this.buildInfo.runNumber, this.buildInfo.getTraceId(), this.buildInfo.getSpanId(), complete);
                    span.setAttribute("completed", logsQueryResult.isComplete());
                    overallLog = new OverallLog(logsQueryResult.getByteBuffer(), logsQueryResult.getLogsViewHeader(), logsQueryResult.getCharset(), logsQueryResult.isComplete(), build, this.tracer);
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception x) {
                        span.recordException((Throwable)x);
                        AnnotatedLargeText annotatedLargeText = new BrokenLogStorage((Throwable)x).overallLog(build, complete);
                        return annotatedLargeText;
                    }
                }
                scope.close();
            }
            return overallLog;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AnnotatedLargeText<FlowNode> stepLog(@NonNull FlowNode flowNode, boolean complete) {
        File logFile = new File(this.buildFolderPath, "log");
        if (logFile.exists()) {
            return FileLogStorage.forFile((File)logFile).stepLog(flowNode, complete);
        }
        Span span = this.tracer.spanBuilder("OtelLogStorage.stepLog").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.buildInfo.getJobFullName()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.buildInfo.runNumber).setAttribute("complete", complete).startSpan();
        try {
            AnnotatedLargeText annotatedLargeText;
            block13: {
                Scope scope = span.makeCurrent();
                try {
                    String traceId = this.buildInfo.getTraceId();
                    String spanId = this.buildInfo.getSpanId();
                    if (traceId == null || spanId == null) {
                        throw new IllegalStateException("traceId or spanId is null for " + this.buildInfo);
                    }
                    LogStorageRetriever logStorageRetriever = this.getLogStorageRetriever();
                    LogsQueryResult logsQueryResult = logStorageRetriever.stepLog(this.buildInfo.getJobFullName(), this.buildInfo.runNumber, flowNode.getId(), traceId, spanId, complete);
                    span.setAttribute("completed", logsQueryResult.isComplete()).setAttribute("length", logsQueryResult.byteBuffer.length());
                    annotatedLargeText = new AnnotatedLargeText(logsQueryResult.getByteBuffer(), logsQueryResult.getCharset(), logsQueryResult.isComplete(), (Object)flowNode);
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception x) {
                        span.recordException((Throwable)x);
                        AnnotatedLargeText annotatedLargeText2 = new BrokenLogStorage((Throwable)x).stepLog(flowNode, complete);
                        return annotatedLargeText2;
                    }
                }
                scope.close();
            }
            return annotatedLargeText;
        }
        finally {
            span.end();
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="forBuild only accepts Run")
    public File getLogFile(FlowExecutionOwner.Executable build, boolean complete) {
        logger.log(Level.FINE, "getLogFile(complete: " + complete + ")");
        Span span = this.tracer.spanBuilder("OtelLogStorage.getLogFile").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.buildInfo.getJobFullName()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.buildInfo.runNumber).setAttribute("complete", complete).startSpan();
        try {
            File file;
            block19: {
                Scope scope = span.makeCurrent();
                try {
                    AnnotatedLargeText<FlowExecutionOwner.Executable> logText = this.overallLog(build, complete);
                    File f = new File(((Run)build).getRootDir(), "log");
                    f.deleteOnExit();
                    try (FileOutputStream os = new FileOutputStream(f);){
                        long pos2;
                        long pos = 0L;
                        while ((pos2 = logText.writeRawLogTo(pos, (OutputStream)os)) > pos) {
                            pos = pos2;
                        }
                    }
                    catch (Exception x) {
                        logger.log(Level.WARNING, null, x);
                        span.recordException((Throwable)x);
                    }
                    file = f;
                    if (scope == null) break block19;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return file;
        }
        finally {
            span.end();
        }
    }

    public String toString() {
        return "OtelLogStorage{buildInfo=" + this.buildInfo + "}";
    }

    @NonNull
    public LogStorageRetriever getLogStorageRetriever() {
        return JenkinsOpenTelemetryPluginConfiguration.get().getLogStorageRetriever();
    }
}

