/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.console.LineTransformationOutputStream;
import io.jenkins.plugins.opentelemetry.job.log.BuildInfo;
import io.jenkins.plugins.opentelemetry.job.log.ConsoleNotes;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.sdk.common.Clock;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

final class OtelLogOutputStream
extends LineTransformationOutputStream {
    public static boolean ENABLE_LOG_FORMATTING = Boolean.parseBoolean(System.getProperty("pipeline.log.elastic.enable.log.formatting", "false"));
    private static final Logger LOGGER = Logger.getLogger(OtelLogOutputStream.class.getName());
    @NonNull
    final BuildInfo buildInfo;
    @Nullable
    String flowNodeId;
    final Map<String, String> w3cTraceContext;
    final io.opentelemetry.api.logs.Logger otelLogger;
    final Context context;
    final Clock clock;

    public OtelLogOutputStream(@NonNull BuildInfo buildInfo, @Nullable String flowNodeId, @NonNull Map<String, String> w3cTraceContext, @NonNull io.opentelemetry.api.logs.Logger otelLogger, @NonNull Clock clock) {
        this.buildInfo = buildInfo;
        this.flowNodeId = flowNodeId;
        this.otelLogger = otelLogger;
        this.clock = clock;
        this.w3cTraceContext = w3cTraceContext;
        this.context = W3CTraceContextPropagator.getInstance().extract(Context.current(), this.w3cTraceContext, (TextMapGetter)new TextMapGetter<Map<String, String>>(){

            public Iterable<String> keys(@Nonnull Map<String, String> carrier) {
                return carrier.keySet();
            }

            @Nullable
            public String get(@Nullable Map<String, String> carrier, @Nonnull String key) {
                return carrier == null ? null : carrier.get(key);
            }
        });
    }

    protected void eol(byte[] bytes, int len) {
        if (len == 0) {
            return;
        }
        ConsoleNotes.TextAndAnnotations textAndAnnotations = ConsoleNotes.parse(bytes, len);
        String plainLogLine = textAndAnnotations.text;
        if (plainLogLine == null || plainLogLine.isEmpty()) {
            LOGGER.log(Level.FINEST, () -> this.buildInfo + " - skip empty log line");
        } else {
            AttributesBuilder attributesBuilder = Attributes.builder();
            if (ENABLE_LOG_FORMATTING && textAndAnnotations.annotations != null) {
                attributesBuilder.put(JenkinsOtelSemanticAttributes.JENKINS_ANSI_ANNOTATIONS, (Object)textAndAnnotations.annotations.toString());
            }
            attributesBuilder.putAll(this.buildInfo.toAttributes());
            if (this.flowNodeId != null) {
                attributesBuilder.put(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)this.flowNodeId);
            }
            this.otelLogger.logRecordBuilder().setSeverity(Severity.INFO).setBody(plainLogLine).setAllAttributes(attributesBuilder.build()).setContext(this.context).setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).emit();
            LOGGER.log(Level.FINEST, () -> this.buildInfo.jobFullName + "#" + this.buildInfo.runNumber + " - emit body: '" + StringUtils.abbreviate((String)plainLogLine, (int)30) + "'");
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

