/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ConsoleNotes {
    private ConsoleNotes() {
    }

    public static TextAndAnnotations parse(byte[] bytes, int len) {
        int endOfPreamble;
        int postamble;
        int preamble;
        byte c;
        int eol;
        assert (len > 0 && len <= bytes.length);
        for (eol = len; eol > 0 && ((c = bytes[eol - 1]) == 10 || c == 13); --eol) {
        }
        String line = new String(bytes, 0, eol, StandardCharsets.UTF_8);
        if (!line.contains("\u001b[8mha:")) {
            return new TextAndAnnotations(line, null);
        }
        StringBuilder buf = new StringBuilder();
        ArrayList<ImmutableMap> annotations = new ArrayList<ImmutableMap>();
        int pos = 0;
        while ((preamble = line.indexOf("\u001b[8mha:", pos)) != -1 && (postamble = line.indexOf("\u001b[0m", endOfPreamble = preamble + "\u001b[8mha:".length())) != -1) {
            buf.append(line, pos, preamble);
            annotations.add(ImmutableMap.of((Object)"position", (Object)buf.length(), (Object)"note", (Object)line.substring(endOfPreamble, postamble)));
            pos = postamble + "\u001b[0m".length();
        }
        buf.append(line, pos, line.length());
        return new TextAndAnnotations(buf.toString(), JSONArray.fromObject(annotations));
    }

    public static String readFormattedMessage(String message, @Nullable JSONArray annotations) {
        if (annotations == null) {
            return message;
        }
        StringWriter formattedMessage = new StringWriter();
        int pos = 0;
        for (Object o : annotations) {
            JSONObject annotation = (JSONObject)o;
            int position = annotation.getInt("position");
            String note = annotation.getString("note");
            formattedMessage.write(message, pos, position - pos);
            formattedMessage.write("\u001b[8mha:");
            formattedMessage.write(note);
            formattedMessage.write("\u001b[0m");
            pos = position;
        }
        formattedMessage.write(message, pos, message.length() - pos);
        return formattedMessage.toString();
    }

    static class TextAndAnnotations {
        final String text;
        @CheckForNull
        final JSONArray annotations;

        public TextAndAnnotations(String text, @Nullable JSONArray annotations) {
            this.text = text;
            this.annotations = annotations;
        }
    }
}

