/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.opentelemetry.Messages;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.DataBoundConstructor;

public class ViewColumn
extends ListViewColumn {
    @DataBoundConstructor
    public ViewColumn() {
    }

    public List<MonitoringAction.ObservabilityBackendLink> getLinks(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return null;
        }
        job.getLastCompletedBuild().getActions(MonitoringAction.class);
        return lastCompletedBuild.getActions(MonitoringAction.class).stream().map(MonitoringAction::getLinks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.observabilityColumn();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

