/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.collect.ComparisonChain;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class RunIdentifier
implements Comparable<RunIdentifier> {
    final String jobName;
    final int runNumber;

    static RunIdentifier fromRun(@NonNull Run run) {
        return new RunIdentifier(run.getParent().getFullName(), run.getNumber());
    }

    static RunIdentifier fromBuild(@NonNull AbstractBuild build) {
        return new RunIdentifier(build.getParent().getFullName(), build.getNumber());
    }

    public RunIdentifier(@NonNull String jobName, @NonNull int runNumber) {
        this.jobName = jobName;
        this.runNumber = runNumber;
    }

    @NonNull
    public String getId() {
        return this.jobName + "#" + this.runNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunIdentifier that = (RunIdentifier)o;
        return this.runNumber == that.runNumber && this.jobName.equals(that.jobName);
    }

    public int hashCode() {
        return Objects.hash(this.jobName, this.runNumber);
    }

    public String toString() {
        return "RunIdentifier{jobName='" + this.jobName + "', runNumber=" + this.runNumber + "}";
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getRunNumber() {
        return this.runNumber;
    }

    @Override
    public int compareTo(RunIdentifier o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.jobName), (Comparable)((Object)o.jobName)).compare(this.runNumber, o.runNumber).result();
    }
}

