/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.job.OtelEnvironmentContributorService;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepEnvironmentContributor;

@Extension
public class OtelStepEnvironmentContributor
extends StepEnvironmentContributor {
    private static final Logger LOGGER = Logger.getLogger(OtelStepEnvironmentContributor.class.getName());
    private OtelEnvironmentContributorService otelEnvironmentContributorService;
    private OtelTraceService otelTraceService;

    public void buildEnvironmentFor(@NonNull StepContext stepContext, @NonNull EnvVars envs, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Span span;
        super.buildEnvironmentFor(stepContext, envs, listener);
        Run run = (Run)stepContext.get(Run.class);
        FlowNode flowNode = (FlowNode)stepContext.get(FlowNode.class);
        if (flowNode == null) {
            LOGGER.log(Level.WARNING, () -> run.getFullDisplayName() + "buildEnvironmentFor() NO flowNode found for context " + stepContext);
            span = this.otelTraceService.getSpan(run);
        } else {
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + "buildEnvironmentFor(flowNode: " + flowNode.getDisplayFunctionName() + ") ");
            span = this.otelTraceService.getSpan(run, flowNode);
        }
        this.otelEnvironmentContributorService.addEnvironmentVariables(run, envs, span);
    }

    @Inject
    public void setEnvironmentContributorService(OtelEnvironmentContributorService otelEnvironmentContributorService) {
        this.otelEnvironmentContributorService = otelEnvironmentContributorService;
    }

    @Inject
    public void setOtelTraceService(OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }
}

