/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.cause.CauseHandler;
import io.jenkins.plugins.opentelemetry.job.opentelemetry.OtelContextAwareAbstractRunListener;
import io.jenkins.plugins.opentelemetry.job.runhandler.RunHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamCause;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringRunListener
extends OtelContextAwareAbstractRunListener {
    protected static final Logger LOGGER = Logger.getLogger(MonitoringRunListener.class.getName());
    private AtomicInteger activeRun;
    private List<CauseHandler> causeHandlers;
    private LongCounter runLaunchedCounter;
    private LongCounter runStartedCounter;
    private LongCounter runCompletedCounter;
    private LongCounter runAbortedCounter;
    private LongCounter runSuccessCounter;
    private LongCounter runFailedCounter;
    private List<RunHandler> runHandlers;

    @PostConstruct
    public void postConstruct() {
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        super.afterSdkInitialized(meter, loggerProvider, eventEmitter, tracer, configProperties);
        ArrayList<CauseHandler> causeHandlers = new ArrayList<CauseHandler>((Collection<CauseHandler>)ExtensionList.lookup(CauseHandler.class));
        causeHandlers.stream().forEach(causeHandler -> causeHandler.configure(configProperties));
        Collections.sort(causeHandlers);
        this.causeHandlers = causeHandlers;
        ArrayList<RunHandler> runHandlers = new ArrayList<RunHandler>((Collection<RunHandler>)ExtensionList.lookup(RunHandler.class));
        runHandlers.stream().forEach(runHandler -> runHandler.configure(configProperties));
        Collections.sort(runHandlers);
        this.runHandlers = runHandlers;
        this.activeRun = new AtomicInteger();
        meter.gaugeBuilder("ci.pipeline.run.active").ofLongs().setDescription("Gauge of active jobs").setUnit("1").buildWithCallback(valueObserver -> this.activeRun.get());
        this.runLaunchedCounter = meter.counterBuilder("ci.pipeline.run.launched").setDescription("Job launched").setUnit("1").build();
        this.runStartedCounter = meter.counterBuilder("ci.pipeline.run.started").setDescription("Job started").setUnit("1").build();
        this.runSuccessCounter = meter.counterBuilder("ci.pipeline.run.success").setDescription("Job succeed").setUnit("1").build();
        this.runFailedCounter = meter.counterBuilder("ci.pipeline.run.failed").setDescription("Job failed").setUnit("1").build();
        this.runAbortedCounter = meter.counterBuilder("ci.pipeline.run.aborted").setDescription("Job aborted").setUnit("1").build();
        this.runCompletedCounter = meter.counterBuilder("ci.pipeline.run.completed").setDescription("Job completed").setUnit("1").build();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins build executions...");
    }

    @NonNull
    public List<CauseHandler> getCauseHandlers() {
        return (List)Preconditions.checkNotNull(this.causeHandlers);
    }

    @NonNull
    public CauseHandler getCauseHandler(@NonNull Cause cause) throws NoSuchElementException {
        return this.getCauseHandlers().stream().filter(ch -> ch.isSupported(cause)).findFirst().get();
    }

    @Override
    public void _onInitialize(@NonNull Run run) {
        ParametersAction parameters;
        LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - onInitialize");
        this.activeRun.incrementAndGet();
        RunHandler runHandler = this.getRunHandlers().stream().filter(rh -> rh.canCreateSpanBuilder(run)).findFirst().orElseThrow(() -> new IllegalStateException("No RunHandler found for run " + run.getClass() + " - " + run));
        SpanBuilder rootSpanBuilder = runHandler.createSpanBuilder(run, this.getTracer());
        rootSpanBuilder.setSpanKind(SpanKind.SERVER);
        String runUrl = Objects.toString(Jenkins.get().getRootUrl(), "") + run.getUrl();
        rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.ELASTIC_TRANSACTION_TYPE, (Object)"job");
        rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)run.getParent().getFullName()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_NAME, (Object)run.getParent().getFullDisplayName()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_URL, (Object)runUrl).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)run.getNumber()).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_TYPE, (Object)OtelUtils.getProjectType(run));
        Set culpritIds = run instanceof WorkflowRun ? ((WorkflowRun)run).getCulprits() : (run instanceof AbstractBuild ? ((AbstractBuild)run).getCulprits() : null);
        if (culpritIds != null) {
            rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_COMMITTERS, culpritIds.stream().map(p -> p.getId()).collect(Collectors.toList()));
        }
        if ((parameters = (ParametersAction)run.getAction(ParametersAction.class)) != null) {
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList<Boolean> parameterIsSensitive = new ArrayList<Boolean>();
            ArrayList<String> nonNullParameterValues = new ArrayList<String>();
            for (ParameterValue parameter : parameters.getParameters()) {
                parameterNames.add(Objects.toString(parameter.getName(), "#NULL#"));
                parameterIsSensitive.add(parameter.isSensitive());
                if (parameter.isSensitive()) {
                    nonNullParameterValues.add("#REDACTED#");
                    continue;
                }
                nonNullParameterValues.add(Objects.toString(parameter.getValue(), "#NULL#"));
            }
            rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_PARAMETER_NAME, parameterNames);
            rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_PARAMETER_IS_SENSITIVE, parameterIsSensitive);
            rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_PARAMETER_VALUE, nonNullParameterValues);
        }
        List causesDescriptions = run.getCauses().stream().map(c -> this.getCauseHandler((Cause)c).getStructuredDescription((Cause)c)).collect(Collectors.toList());
        rootSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_CAUSE, causesDescriptions);
        Optional optCause = run.getCauses().stream().findFirst();
        optCause.ifPresent(cause -> {
            Cause.UpstreamCause upstreamCause;
            Run upstreamRun;
            if (cause instanceof Cause.UpstreamCause && (upstreamRun = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) != null) {
                Map<Object, Object> carrier;
                MonitoringAction monitoringAction = (MonitoringAction)upstreamRun.getAction(MonitoringAction.class);
                if (monitoringAction == null) {
                    carrier = Collections.emptyMap();
                } else if (upstreamCause instanceof BuildUpstreamCause) {
                    BuildUpstreamCause buildUpstreamCause = (BuildUpstreamCause)cause;
                    String upstreamNodeId = buildUpstreamCause.getNodeId();
                    carrier = monitoringAction.getContext(upstreamNodeId);
                } else {
                    carrier = monitoringAction.getRootContext();
                }
                Context context = W3CTraceContextPropagator.getInstance().extract(Context.current(), carrier, (TextMapGetter)new TextMapGetter<Map<String, String>>(){

                    public Iterable<String> keys(Map<String, String> carrier) {
                        return carrier.keySet();
                    }

                    @Nullable
                    public String get(@Nullable Map<String, String> carrier, String key) {
                        return carrier == null ? null : carrier.get(key);
                    }
                });
                rootSpanBuilder.setParent(context);
            }
        });
        Span rootSpan = rootSpanBuilder.startSpan();
        String traceId = rootSpan.getSpanContext().getTraceId();
        String spanId = rootSpan.getSpanContext().getSpanId();
        String rootSpanName = rootSpan instanceof ReadWriteSpan ? ((ReadWriteSpan)rootSpan).getName() : null;
        MonitoringAction monitoringAction = new MonitoringAction(traceId, spanId, rootSpanName);
        run.addAction((Action)monitoringAction);
        this.getTraceService().putSpan(run, rootSpan);
        try (Scope rootSpanScope = rootSpan.makeCurrent();){
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin root " + OtelUtils.toDebugString(rootSpan));
            HashMap<String, String> context = new HashMap<String, String>();
            W3CTraceContextPropagator.getInstance().inject(Context.current(), context, (carrier, key, value) -> carrier.put(key, value));
            monitoringAction.addRootContext(context);
            Span startSpan = this.getTracer().spanBuilder("Phase: Start").setParent(Context.current().with((ImplicitContextKeyed)rootSpan)).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(startSpan));
            this.getTraceService().putSpan(run, startSpan);
            try (Scope startSpanScope = startSpan.makeCurrent();){
                this.runLaunchedCounter.add(1L);
            }
        }
    }

    @Override
    public void _onStarted(@NonNull Run run, @NonNull TaskListener listener) {
        try (Scope parentScope = this.endPipelinePhaseSpan(run);){
            Span runSpan = this.getTracer().spanBuilder("Phase: Run").setParent(Context.current()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(runSpan));
            try (Scope scope = runSpan.makeCurrent();){
                this.getTraceService().putSpan(run, runSpan);
                if (run instanceof AbstractBuild) {
                    this.getTraceService().putSpan((AbstractBuild)run, runSpan);
                }
                this.runStartedCounter.add(1L);
            }
        }
    }

    @Override
    public void _onCompleted(@NonNull Run run, @NonNull TaskListener listener) {
        try (Scope parentScope = this.endPipelinePhaseSpan(run);){
            Span finalizeSpan = this.getTracer().spanBuilder("Phase: Finalise").setParent(Context.current()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(finalizeSpan));
            try (Scope scope = finalizeSpan.makeCurrent();){
                this.getTraceService().putSpan(run, finalizeSpan);
            }
        }
    }

    @MustBeClosed
    @NonNull
    protected Scope endPipelinePhaseSpan(@NonNull Run run) {
        Span pipelinePhaseSpan = (Span)Verify.verifyNotNull((Object)Span.current(), (String)"No pipelinePhaseSpan found in context", (Object[])new Object[0]);
        pipelinePhaseSpan.end();
        LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - end " + OtelUtils.toDebugString(pipelinePhaseSpan));
        this.getTraceService().removeJobPhaseSpan(run, pipelinePhaseSpan);
        Span newCurrentSpan = this.getTraceService().getSpan(run);
        return newCurrentSpan.makeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _onFinalized(@NonNull Run run) {
        try (Scope parentScope = this.endPipelinePhaseSpan(run);){
            Node node;
            Result runResult;
            Span parentSpan = Span.current();
            parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_DURATION_MILLIS, (Object)run.getDuration());
            String description = run.getDescription();
            if (description != null) {
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_DESCRIPTION, (Object)description);
            }
            if (OtelUtils.isMultibranch(run)) {
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_MULTIBRANCH_TYPE, (Object)OtelUtils.getMultibranchType(run));
            }
            if ((runResult = run.getResult()) == null) {
                parentSpan.setStatus(StatusCode.UNSET);
            } else {
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_COMPLETED, (Object)runResult.completeBuild);
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_RESULT, (Object)Objects.toString(runResult, null));
                if (Result.SUCCESS.equals(runResult)) {
                    parentSpan.setStatus(StatusCode.OK, runResult.toString());
                } else if (Result.FAILURE.equals(runResult) || Result.UNSTABLE.equals(runResult)) {
                    parentSpan.setAttribute(SemanticAttributes.EXCEPTION_TYPE, (Object)("PIPELINE_" + runResult));
                    parentSpan.setAttribute(SemanticAttributes.EXCEPTION_MESSAGE, (Object)("PIPELINE_" + runResult));
                    parentSpan.setStatus(StatusCode.ERROR, runResult.toString());
                } else if (Result.ABORTED.equals(runResult) || Result.NOT_BUILT.equals(runResult)) {
                    parentSpan.setStatus(StatusCode.UNSET, runResult.toString());
                }
            }
            if (run instanceof AbstractBuild && (node = ((AbstractBuild)run).getBuiltOn()) != null) {
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_AGENT_LABEL, (Object)node.getLabelString());
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_AGENT_ID, (Object)node.getNodeName());
                parentSpan.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_AGENT_NAME, (Object)node.getDisplayName());
            }
            parentSpan.end();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - end " + OtelUtils.toDebugString(parentSpan));
            this.getTraceService().removeJobPhaseSpan(run, parentSpan);
            this.getTraceService().purgeRun(run);
            Result result = (Result)Verify.verifyNotNull((Object)run.getResult(), (String)"%s", (Object[])new Object[]{run});
            if (result.isCompleteBuild()) {
                LOGGER.log(Level.FINE, () -> "Increment completion counters");
                this.runCompletedCounter.add(1L);
                if (result.equals(Result.SUCCESS)) {
                    this.runSuccessCounter.add(1L);
                } else {
                    this.runFailedCounter.add(1L);
                }
            } else {
                this.runAbortedCounter.add(1L);
            }
        }
        finally {
            this.activeRun.decrementAndGet();
        }
    }

    @NonNull
    protected List<RunHandler> getRunHandlers() {
        return (List)Preconditions.checkNotNull(this.runHandlers);
    }
}

