/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Verify;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetryAttributesAction;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.job.jenkins.AbstractPipelineListener;
import io.jenkins.plugins.opentelemetry.job.jenkins.PipelineListener;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.CauseOfInterruption;
import org.apache.commons.compress.utils.Sets;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.StepListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.CoreStep;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringPipelineListener
extends AbstractPipelineListener
implements PipelineListener,
StepListener,
OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(MonitoringPipelineListener.class.getName());
    private OtelTraceService otelTraceService;
    private Tracer tracer;
    private Set<String> ignoredSteps;
    private List<StepHandler> stepHandlers;
    Set<String> statusUnsetCausesOfInterruption;

    @PostConstruct
    public void postConstruct() {
        JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration = JenkinsOpenTelemetryPluginConfiguration.get();
        this.ignoredSteps = Sets.newHashSet((Object[])jenkinsOpenTelemetryPluginConfiguration.getIgnoredSteps().split(","));
        this.statusUnsetCausesOfInterruption = new HashSet<String>(jenkinsOpenTelemetryPluginConfiguration.getStatusUnsetCausesOfInterruption());
    }

    @Override
    public void onStartNodeStep(@NonNull StepStartNode stepStartNode, @Nullable String agentLabel, @NonNull WorkflowRun run) {
        try (Scope nodeSpanScope = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)nodeSpanScope, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "node");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            SpanBuilder agentSpanBuilder = this.getTracer().spanBuilder("Agent").setParent(Context.current()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_NAME, (Object)"agent").setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
            if (agentLabel != null) {
                agentSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_AGENT_LABEL, (Object)agentLabel);
            }
            Span agentSpan = agentSpanBuilder.startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > agent(" + agentLabel + ") - begin " + OtelUtils.toDebugString(agentSpan));
            this.getTracerService().putSpan((Run)run, agentSpan, (FlowNode)stepStartNode);
            try (Scope allocateAgentSpanScope = agentSpan.makeCurrent();){
                SpanBuilder allocateAgentSpanBuilder = this.getTracer().spanBuilder("Agent Allocation").setParent(Context.current()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_TYPE, (Object)this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "node")).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_NAME, (Object)"agent.allocate").setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
                if (agentLabel != null) {
                    allocateAgentSpanBuilder.setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_AGENT_LABEL, (Object)agentLabel);
                }
                Span allocateAgentSpan = allocateAgentSpanBuilder.startSpan();
                LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > agent.allocate(" + agentLabel + ") - begin " + OtelUtils.toDebugString(allocateAgentSpan));
                this.getTracerService().putSpan((Run)run, allocateAgentSpan, (FlowNode)stepStartNode);
            }
        }
    }

    @Override
    public void onAfterStartNodeStep(@NonNull StepStartNode stepStartNode, @Nullable String nodeLabel, @NonNull WorkflowRun run) {
        this.endCurrentSpan((FlowNode)stepStartNode, run);
    }

    @Override
    public void onStartStageStep(@NonNull StepStartNode stepStartNode, @NonNull String stageName, @NonNull WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String spanStageName = "Stage: " + stageName;
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "stage");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            Span stageSpan = this.getTracer().spanBuilder(spanStageName).setParent(Context.current()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_NAME, (Object)stageName).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > stage(" + stageName + ") - begin " + OtelUtils.toDebugString(stageSpan));
            this.getTracerService().putSpan((Run)run, stageSpan, (FlowNode)stepStartNode);
        }
    }

    @Override
    public void onEndNodeStep(@NonNull StepEndNode node, @NonNull String nodeName, @NonNull WorkflowRun run) {
        this.endCurrentSpan((FlowNode)node, run);
    }

    @Override
    public void onEndStageStep(@NonNull StepEndNode node, @NonNull String stageName, @NonNull WorkflowRun run) {
        this.endCurrentSpan((FlowNode)node, run);
    }

    protected List<StepHandler> getStepHandlers() {
        if (this.stepHandlers == null) {
            ArrayList<StepHandler> stepHandlers = new ArrayList<StepHandler>((Collection<StepHandler>)ExtensionList.lookup(StepHandler.class));
            Collections.sort(stepHandlers);
            this.stepHandlers = stepHandlers;
        }
        return this.stepHandlers;
    }

    @Override
    public void onAtomicStep(@NonNull StepAtomNode node, @NonNull WorkflowRun run) {
        if (this.isIgnoredStep(node.getDescriptor())) {
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - don't create span for step '" + node.getDisplayFunctionName() + "'");
            return;
        }
        try (Scope ignored = this.setupContext(run, (FlowNode)node);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, node});
            String principal = Objects.toString(node.getExecution().getAuthentication().getPrincipal(), "#null#");
            LOGGER.log(Level.FINE, () -> node.getDisplayFunctionName() + " - principal: " + principal);
            StepHandler stepHandler = this.getStepHandlers().stream().filter(sh -> sh.canCreateSpanBuilder((FlowNode)node, run)).findFirst().orElseThrow(() -> new IllegalStateException("No StepHandler found for node " + node.getClass() + " - " + node + " on " + run));
            SpanBuilder spanBuilder = stepHandler.createSpanBuilder((FlowNode)node, run, this.getTracer());
            String stepType = this.getStepType((FlowNode)node, node.getDescriptor(), "step");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, node);
            spanBuilder.setParent(Context.current()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)node.getId()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_NAME, (Object)this.getStepName(node, "step")).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_USER, (Object)principal).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
            Span atomicStepSpan = spanBuilder.startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > " + node.getDisplayFunctionName() + " - begin " + OtelUtils.toDebugString(atomicStepSpan));
            try (Scope ignored2 = atomicStepSpan.makeCurrent();){
                stepHandler.afterSpanCreated(node, run);
            }
            this.getTracerService().putSpan((Run)run, atomicStepSpan, (FlowNode)node);
        }
    }

    @Override
    public void onAfterAtomicStep(@NonNull StepAtomNode node, @NonNull WorkflowRun run) {
        if (this.isIgnoredStep(node.getDescriptor())) {
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - don't end span for step '" + node.getDisplayFunctionName() + "'");
            return;
        }
        this.endCurrentSpan((FlowNode)node, run);
    }

    private boolean isIgnoredStep(@Nullable StepDescriptor stepDescriptor) {
        if (stepDescriptor == null) {
            return true;
        }
        String stepFunctionName = stepDescriptor.getFunctionName();
        boolean ignoreStep = "withSpanAttribute".equals(stepFunctionName) || this.ignoredSteps.contains(stepFunctionName);
        LOGGER.log(Level.FINER, () -> "isIgnoreStep(" + stepDescriptor + "): " + ignoreStep);
        return ignoreStep;
    }

    private String getStepName(@NonNull StepAtomNode node, @NonNull String name) {
        StepDescriptor stepDescriptor = node.getDescriptor();
        if (stepDescriptor == null) {
            return name;
        }
        UninstantiatedDescribable describable = this.getUninstantiatedDescribableOrNull((FlowNode)node, stepDescriptor);
        if (describable != null) {
            Descriptor d = SymbolLookup.get().findDescriptor(Describable.class, describable.getSymbol());
            return d.getDisplayName();
        }
        return stepDescriptor.getDisplayName();
    }

    private String getStepType(@NonNull FlowNode node, @Nullable StepDescriptor stepDescriptor, @NonNull String type) {
        if (stepDescriptor == null) {
            return type;
        }
        UninstantiatedDescribable describable = this.getUninstantiatedDescribableOrNull(node, stepDescriptor);
        if (describable != null) {
            return describable.getSymbol();
        }
        return stepDescriptor.getFunctionName();
    }

    @Nullable
    private UninstantiatedDescribable getUninstantiatedDescribableOrNull(@NonNull FlowNode node, @Nullable StepDescriptor stepDescriptor) {
        Map arguments;
        if (stepDescriptor instanceof CoreStep.DescriptorImpl && (arguments = ArgumentsAction.getFilteredArguments((FlowNode)node)).get("delegate") instanceof UninstantiatedDescribable) {
            return (UninstantiatedDescribable)arguments.get("delegate");
        }
        return null;
    }

    @Override
    public void onStartParallelStepBranch(@NonNull StepStartNode stepStartNode, @NonNull String branchName, @NonNull WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "branch");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            Span atomicStepSpan = this.getTracer().spanBuilder("Parallel branch: " + branchName).setParent(Context.current()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_NAME, (Object)branchName).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > parallel branch(" + branchName + ") - begin " + OtelUtils.toDebugString(atomicStepSpan));
            this.getTracerService().putSpan((Run)run, atomicStepSpan, (FlowNode)stepStartNode);
        }
    }

    @Override
    public void onEndParallelStepBranch(@NonNull StepEndNode node, @NonNull String branchName, @NonNull WorkflowRun run) {
        this.endCurrentSpan((FlowNode)node, run);
    }

    private void endCurrentSpan(FlowNode node, WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, node);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, node});
            Span span = this.getTracerService().getSpan((Run)run, node);
            ErrorAction errorAction = node.getError();
            if (errorAction == null) {
                span.setStatus(StatusCode.OK);
            } else {
                Throwable throwable = errorAction.getError();
                if (throwable instanceof FlowInterruptedException) {
                    FlowInterruptedException interruptedException = (FlowInterruptedException)throwable;
                    List causesOfInterruption = interruptedException.getCauses();
                    List causeDescriptions = causesOfInterruption.stream().map(cause -> cause.getClass().getSimpleName() + ": " + cause.getShortDescription()).collect(Collectors.toList());
                    span.setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_INTERRUPTION_CAUSES, causeDescriptions);
                    String statusDescription = throwable.getClass().getSimpleName() + ": " + causeDescriptions.stream().collect(Collectors.joining(", "));
                    boolean suppressSpanStatusCodeError = false;
                    for (CauseOfInterruption causeOfInterruption : causesOfInterruption) {
                        if (!this.statusUnsetCausesOfInterruption.contains(causeOfInterruption.getClass().getName())) continue;
                        suppressSpanStatusCodeError = true;
                        break;
                    }
                    if (suppressSpanStatusCodeError) {
                        span.setStatus(StatusCode.UNSET, statusDescription);
                    } else {
                        span.recordException(throwable);
                        span.setStatus(StatusCode.ERROR, statusDescription);
                    }
                } else {
                    span.recordException(throwable);
                    span.setStatus(StatusCode.ERROR, throwable.getMessage());
                }
            }
            span.end();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - < " + node.getDisplayFunctionName() + " - end " + OtelUtils.toDebugString(span));
            this.getTracerService().removePipelineStepSpan((Run)run, node, span);
        }
    }

    public void notifyOfNewStep(@NonNull Step step, @NonNull StepContext context) {
        try {
            WorkflowRun run = (WorkflowRun)context.get(WorkflowRun.class);
            FlowNode node = (FlowNode)context.get(FlowNode.class);
            Computer computer = (Computer)context.get(Computer.class);
            if (computer == null || node == null || run == null) {
                LOGGER.log(Level.FINER, () -> "No run, flowNode or computer, skip. Run:" + run + ", flowNode: " + node + ", computer:" + computer);
                return;
            }
            if (computer.getAction(OpenTelemetryAttributesAction.class) == null) {
                LOGGER.log(Level.WARNING, "Unexpected missing " + OpenTelemetryAttributesAction.class + " on " + computer + " fallback");
                String hostName = computer.getHostName();
                OpenTelemetryAttributesAction openTelemetryAttributesAction = new OpenTelemetryAttributesAction();
                openTelemetryAttributesAction.getAttributes().put(ResourceAttributes.HOST_NAME, hostName);
                computer.addAction((Action)openTelemetryAttributesAction);
            }
            OpenTelemetryAttributesAction openTelemetryAttributesAction = (OpenTelemetryAttributesAction)computer.getAction(OpenTelemetryAttributesAction.class);
            try (Scope ignored = this.setupContext(run, node);){
                Span currentSpan = Span.current();
                LOGGER.log(Level.FINE, () -> "Add resource attributes to span " + OtelUtils.toDebugString(currentSpan) + " - " + openTelemetryAttributesAction);
                for (Map.Entry<AttributeKey<?>, Object> entry : openTelemetryAttributesAction.getAttributes().entrySet()) {
                    AttributeKey<?> attributeKey = entry.getKey();
                    Object value = Verify.verifyNotNull((Object)entry.getValue());
                    currentSpan.setAttribute(attributeKey, value);
                }
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception processing " + step + " - " + context, e);
        }
    }

    @NonNull
    @MustBeClosed
    protected Scope setupContext(WorkflowRun run, @NonNull FlowNode node) {
        run = (WorkflowRun)Verify.verifyNotNull((Object)run, (String)"%s No run found for node %s", (Object[])new Object[]{run, node});
        Span span = this.otelTraceService.getSpan((Run)run, node);
        return span.makeCurrent();
    }

    @Inject
    public final void setOpenTelemetryTracerService(@NonNull OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }

    @NonNull
    public OtelTraceService getTracerService() {
        return this.otelTraceService;
    }

    @NonNull
    public Tracer getTracer() {
        return this.tracer;
    }

    public String toString() {
        return "TracingPipelineListener{}";
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.tracer = tracer;
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins pipeline executions...");
    }

    @Override
    public void beforeSdkShutdown() {
    }
}

