/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import io.jenkins.plugins.opentelemetry.jenkins.CredentialsNotFoundException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;

public class JenkinsCredentialsToApacheHttpCredentialsAdapter
implements Credentials {
    Supplier<String> jenkinsCredentialsIdProvider;
    UsernamePasswordCredentials jenkinsUsernamePasswordCredentials;

    public JenkinsCredentialsToApacheHttpCredentialsAdapter(Supplier<String> jenkinsCredentialsIdProvider) {
        this.jenkinsCredentialsIdProvider = jenkinsCredentialsIdProvider;
    }

    public Principal getUserPrincipal() throws CredentialsNotFoundException {
        return new BasicUserPrincipal(this.getJenkinsUsernamePasswordCredentials().getUsername());
    }

    public String getPassword() throws CredentialsNotFoundException {
        return this.getJenkinsUsernamePasswordCredentials().getPassword().getPlainText();
    }

    UsernamePasswordCredentials getJenkinsUsernamePasswordCredentials() throws CredentialsNotFoundException {
        if (this.jenkinsUsernamePasswordCredentials == null) {
            String jenkinsCredentialsId = this.jenkinsCredentialsIdProvider.get();
            if (jenkinsCredentialsId == null || jenkinsCredentialsId.isEmpty()) {
                throw new CredentialsNotFoundException("No Jenkins credentials defined");
            }
            try {
                this.jenkinsUsernamePasswordCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)jenkinsCredentialsId));
            }
            catch (NoSuchElementException e) {
                throw new CredentialsNotFoundException("No Jenkins credentials found for id '" + jenkinsCredentialsId + "' and expected type 'UsernamePasswordCredentials'");
            }
        }
        return this.jenkinsUsernamePasswordCredentials;
    }

    public String toString() {
        return "JenkinsCredentialsToApacheHttpCredentialsAdapter{jenkinsUsernamePasswordCredentials=" + this.jenkinsUsernamePasswordCredentials + "}";
    }
}

