/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.servlet.OpenTelemetryServletFilter;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class ServletFilterInitializer
implements OtelComponent {
    private static final Logger logger = Logger.getLogger(ServletFilterInitializer.class.getName());
    OpenTelemetryServletFilter openTelemetryServletFilter;

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        boolean jenkinsWebInstrumentationEnabled = Optional.ofNullable(configProperties.getBoolean("otel.instrumentation.jenkins.web.enabled")).orElse(true);
        if (jenkinsWebInstrumentationEnabled) {
            this.openTelemetryServletFilter = new OpenTelemetryServletFilter(tracer);
            if (PluginServletFilter.hasFilter((Filter)this.openTelemetryServletFilter)) {
                logger.log(Level.INFO, () -> "Jenkins Web instrumentation already enabled");
            } else {
                try {
                    PluginServletFilter.addFilter((Filter)this.openTelemetryServletFilter);
                    logger.log(Level.FINE, () -> "Jenkins Web instrumentation enabled");
                }
                catch (ServletException ex) {
                    logger.log(Level.WARNING, "Failure to enable Jenkins Web instrumentation", ex);
                }
            }
        } else {
            logger.log(Level.INFO, () -> "Jenkins Web instrumentation disabled");
        }
    }

    @Override
    public void beforeSdkShutdown() {
        try {
            PluginServletFilter.removeFilter((Filter)this.openTelemetryServletFilter);
        }
        catch (ServletException e) {
            logger.log(Level.INFO, "Exception removing OpenTelemetryServletFilter", e);
        }
    }
}

