/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class OtelJulHandler
extends Handler
implements OtelComponent {
    private static final Logger logger = Logger.getLogger(OtelJulHandler.class.getName());
    private static final Formatter FORMATTER = new AccessibleFormatter();
    private boolean captureExperimentalAttributes;
    private LoggerProvider loggerProvider;
    private boolean initialized;
    private boolean disabled = false;

    public OtelJulHandler() {
        try {
            Context context = Context.current();
            logger.log(Level.FINER, () -> "OtelJulHandler initialization - context: " + context);
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            logger.log(Level.WARNING, "Exception initializing OPenTelemetry SDK logging apis, disable OtelJulHandler");
            throw e;
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.disabled) {
            return;
        }
        try {
            String instrumentationName = logRecord.getLoggerName();
            if (instrumentationName == null || instrumentationName.isEmpty()) {
                instrumentationName = "ROOT";
            }
            LogRecordBuilder logBuilder = this.loggerProvider.get(instrumentationName).logRecordBuilder();
            String message = FORMATTER.formatMessage(logRecord);
            if (message != null) {
                logBuilder = logBuilder.setBody(message);
            }
            Instant timestamp = logRecord.getInstant();
            logBuilder = logBuilder.setTimestamp(timestamp);
            Level level = logRecord.getLevel();
            if (level != null) {
                logBuilder = logBuilder.setSeverity(OtelJulHandler.levelToSeverity(level)).setSeverityText(logRecord.getLevel().getName());
            }
            AttributesBuilder attributes = Attributes.builder();
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
                attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
                StringWriter writer = new StringWriter();
                throwable.printStackTrace(new PrintWriter(writer));
                attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
            }
            if (this.captureExperimentalAttributes) {
                Thread currentThread = Thread.currentThread();
                attributes.put(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName());
                attributes.put(SemanticAttributes.THREAD_ID, (Object)currentThread.getId());
            } else {
                attributes.put(SemanticAttributes.THREAD_ID, logRecord.getThreadID());
            }
            logBuilder = logBuilder.setAllAttributes(attributes.build()).setContext(Context.current());
            logBuilder.emit();
        }
        catch (RuntimeException e) {
            System.err.println("Exception sending logs to OTLP endpoint, disable OTelJulHandler");
            e.printStackTrace();
            this.disabled = true;
        }
    }

    private static Severity levelToSeverity(Level level) {
        int lev = level.intValue();
        if (lev <= Level.FINEST.intValue()) {
            return Severity.TRACE;
        }
        if (lev <= Level.FINER.intValue()) {
            return Severity.DEBUG;
        }
        if (lev <= Level.FINE.intValue()) {
            return Severity.DEBUG2;
        }
        if (lev <= Level.CONFIG.intValue()) {
            return Severity.DEBUG3;
        }
        if (lev <= Level.INFO.intValue()) {
            return Severity.INFO;
        }
        if (lev <= Level.WARNING.intValue()) {
            return Severity.WARN;
        }
        if (lev <= Level.SEVERE.intValue()) {
            return Severity.ERROR;
        }
        return Severity.FATAL;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.loggerProvider = loggerProvider;
        this.captureExperimentalAttributes = configProperties.getBoolean("otel.instrumentation.java-util-logging.experimental-log-attributes", false);
        if (!this.initialized) {
            Logger.getLogger("").addHandler(this);
            logger.log(Level.FINE, "Otel Logging initialized");
            this.initialized = true;
        }
    }

    @Override
    public int ordinal() {
        return Integer.MIN_VALUE;
    }

    private static class AccessibleFormatter
    extends Formatter {
        private AccessibleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            throw new UnsupportedOperationException();
        }
    }
}

